/*
 * Decompiled with CFR 0.152.
 */
package css.component;

import css.Style;
import css.StylesheetLoader;
import css.animate.Animation;
import css.component.StyleValue;
import css.component.StyleValueStack;
import css.component.ValueSetter;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import net.model3.bean.ReflectionTool;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3.collections.SetX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.Visitor;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.swing.GuiHelper;

public class ComponentWrapper {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final ReflectionTool _reflectionTool = ((StylesheetLoader)DependencyInjector.getInstance(StylesheetLoader.class)).getReflectionTool();
    JComponent _component;
    List<Style> _attachedStyles = ListX.create();
    Set<Style> _activeStyles = SetX.create();
    Map<String, StyleValueStack> _propertyValues = MapX.create();
    Set<String> _styleClasses = SetX.create();
    Map<Object, Object> _attributes;

    private ComponentWrapper(JComponent jComponent) {
        this._component = jComponent;
    }

    public <T> T getAttribute(Object object) {
        return (T)this.getAttributes().get(object);
    }

    public void setAttribute(Object object, Object object2) {
        this.getAttributes().put(object, object2);
    }

    public void removeAttribute(Object object) {
        this.getAttributes().remove(object);
    }

    private Map<Object, Object> getAttributes() {
        if (this._attributes == null) {
            this._attributes = MapX.create();
        }
        return this._attributes;
    }

    public boolean attachStyle(Style style) {
        if (!this._attachedStyles.contains(style)) {
            this._attachedStyles.add(style);
            return true;
        }
        return false;
    }

    public void detachStyle(Style style) {
        if (this._attachedStyles.contains(style)) {
            this._attachedStyles.remove(style);
            this.deactivate(style);
        }
    }

    public void activate(final Style style) {
        if (style.isActivatable(this._component)) {
            this._activeStyles.add(style);
            for (Map.Entry<String, Object> entry : style.getValues().entrySet()) {
                this.setProperty(style, entry.getKey(), entry.getValue());
            }
            if (style.getDescendantStyles().size() > 0) {
                GuiHelper.visitDescendants((Component)this._component, (Visitor)new Visitor<JComponent>(){

                    public void visit(JComponent jComponent) {
                        for (Style style2 : style.getDescendantStyles()) {
                            style2.attach(jComponent);
                        }
                    }
                });
            }
        }
    }

    public void deactivate(final Style style) {
        if (this._activeStyles.contains(style)) {
            this._activeStyles.remove(style);
            for (Map.Entry<String, Object> entry : style.getValues().entrySet()) {
                this.removeProperty(style, entry.getKey());
            }
            if (style.getDescendantStyles().size() > 0) {
                GuiHelper.visitDescendants((Component)this._component, (Visitor)new Visitor<JComponent>(){

                    public void visit(JComponent jComponent) {
                        for (Style style2 : style.getDescendantStyles()) {
                            style2.detach(jComponent);
                        }
                    }
                });
            }
        }
    }

    public void reapplyStyles() {
        for (Style style : this._attachedStyles) {
            boolean bl;
            boolean bl2 = this._activeStyles.contains(style);
            if (bl2 == (bl = style.isActivatable(this._component))) continue;
            if (bl) {
                this.activate(style);
                continue;
            }
            this.deactivate(style);
        }
    }

    public void addStyleClass(String string) {
        this.getStyleClasses().add(string);
        this.reapplyStyles();
    }

    public boolean removeStyleClass(String string) {
        if (this.getStyleClasses().remove(string)) {
            this.reapplyStyles();
            return true;
        }
        return false;
    }

    public Set<String> getStyleClasses() {
        if (this._styleClasses == null) {
            this._styleClasses = SetX.create();
        }
        return this._styleClasses;
    }

    public List<Style> getAttachedStyles() {
        return this._attachedStyles;
    }

    public Set<Style> getActiveStyles() {
        return this._activeStyles;
    }

    public Map<String, StyleValueStack> getPropertyValues() {
        return this._propertyValues;
    }

    public void setProperty(Style style, String string, Object object) {
        StyleValue styleValue = this.setPropertyInValueStack(style, string, object);
        if (object instanceof ValueSetter) {
            styleValue.stopAnimation();
            ((ValueSetter)object).setValue(this._component, string, object);
        } else {
            this.setPropertyDirect(string, object);
        }
    }

    public StyleValue setPropertyInValueStack(Style style, String string, Object object) {
        StyleValueStack styleValueStack = this.getValueStack(string);
        StyleValue styleValue = styleValueStack.getCurrentValue();
        styleValueStack.setValueForStyle(style, object);
        return styleValue;
    }

    public void setPropertyDirect(String string, Object object) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"setting property {} = {}", (Object)string, object);
        }
        _reflectionTool.setBeanProperty((Object)this._component, string, object);
    }

    public void removeProperty(Style style, String string) {
        StyleValueStack styleValueStack = this.getValueStack(string);
        StyleValue styleValue = styleValueStack.getCurrentValue();
        styleValueStack.removeValueForStyle(style);
        if (styleValue != styleValueStack.getCurrentValue()) {
            Object object = styleValueStack.getCurrentValue().getCanonicalValue();
            if (styleValue.isAnimated()) {
                styleValue.stopAnimation();
                new Animation(styleValue.getAnimationDefinition(), this._component, object);
            } else {
                this.setPropertyDirect(string, object);
            }
        }
    }

    StyleValueStack getValueStack(String string) {
        StyleValueStack styleValueStack = this.getPropertyValues().get(string);
        if (styleValueStack == null) {
            styleValueStack = new StyleValueStack();
            styleValueStack.setValueForStyle(Style.NO_STYLE, _reflectionTool.getBeanProperty((Object)this._component, string));
            this.getPropertyValues().put(string, styleValueStack);
        }
        return styleValueStack;
    }

    public static final ComponentWrapper get(Component component) {
        return ComponentWrapper.get(component, true);
    }

    public static final ComponentWrapper get(Component component, boolean bl) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            ComponentWrapper componentWrapper = (ComponentWrapper)jComponent.getClientProperty(ComponentWrapper.class);
            if (componentWrapper == null && bl) {
                componentWrapper = new ComponentWrapper(jComponent);
                jComponent.putClientProperty(ComponentWrapper.class, componentWrapper);
            }
            return componentWrapper;
        }
        throw new RuntimeException("wrappers only for JComponents");
    }

    public Object getPropertyValue(String string) {
        return _reflectionTool.getBeanProperty((Object)this._component, string);
    }

    public JComponent getComponent() {
        return this._component;
    }
}

