/*
 * Decompiled with CFR 0.152.
 */
package css.animate;

import css.animate.AnimationDefinition;
import css.component.ComponentWrapper;
import java.awt.Color;
import java.awt.Component;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;

public class Animation {
    AnimationDefinition _animationDefinition;
    Object _initialValue;
    Object _targetValue;
    ComponentWrapper _wrapper;
    Animator _animator;
    boolean _running = false;

    public Animation(AnimationDefinition animationDefinition, Component component, Object object) {
        this._animationDefinition = animationDefinition;
        this._targetValue = object;
        this._wrapper = ComponentWrapper.get(component);
        this._initialValue = this._wrapper.getPropertyValue(this._animationDefinition.getPropertyName());
        this._animator = new Animator((int)this._animationDefinition.getDuration().inMilliseconds());
        this._animator.addTarget((TimingTarget)new TimingTargetAdapter(){

            public void timingEvent(float f) {
                Animation.this._wrapper.setPropertyDirect(Animation.this._animationDefinition.getPropertyName(), Animation.this.interpolate(f));
            }

            public void end() {
                Animation.this.stop();
            }
        });
        Animation animation = (Animation)this._wrapper.getAttribute(this._animationDefinition.getAnimationKey());
        if (animation != null) {
            animation.stop();
        }
        this._wrapper.setAttribute(this._animationDefinition.getAnimationKey(), this);
        this._wrapper.setPropertyInValueStack(this._animationDefinition.getStyle(), this._animationDefinition.getPropertyName(), this);
        this._running = true;
        this._animator.start();
    }

    public void stop() {
        if (this._running) {
            this._running = false;
            Animation animation = (Animation)this._wrapper.getAttribute(this._animationDefinition.getAnimationKey());
            if (animation == this) {
                this._wrapper.removeAttribute(animation);
            }
            this._animator.stop();
        }
    }

    Object interpolate(double d) {
        if (this._initialValue instanceof Integer) {
            int n = (Integer)this._initialValue;
            int n2 = (Integer)this._targetValue;
            return n + (int)((double)(n2 - n) * d);
        }
        if (this._initialValue instanceof Color) {
            Color color = (Color)this._initialValue;
            Color color2 = (Color)this._targetValue;
            return new Color(color.getRed() + (int)((double)(color2.getRed() - color.getRed()) * d), color.getGreen() + (int)((double)(color2.getGreen() - color.getGreen()) * d), color.getBlue() + (int)((double)(color2.getBlue() - color.getBlue()) * d), color.getAlpha() + (int)((double)(color2.getAlpha() - color.getAlpha()) * d));
        }
        throw new IllegalArgumentException("cannot interpolate values of type " + this._initialValue.getClass());
    }

    public AnimationDefinition getAnimationDefinition() {
        return this._animationDefinition;
    }

    public Object getTargetValue() {
        return this._targetValue;
    }
}

