/*
 * Decompiled with CFR 0.152.
 */
package css;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import css.Stylesheet;
import css.impl.StylesheetImpl;
import css.loader.StylesheetParser;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.net.URL;
import java.util.Map;
import net.model3.bean.ReflectionTool;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3.lang.ThreadScheduler;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.net.UrlX;
import net.model3.newfile.File;

@Singleton
public class StylesheetLoader {
    Binding _binding = new Binding();
    GroovyShell _shell = new GroovyShell(this._binding);
    Runnable _reloaderRunnable;
    ReflectionTool _reflectionTool = new ReflectionTool(false);
    Map<UrlX, StylesheetSource> _loadedStylesheets = MapX.create();
    @Inject
    Injector _injector;

    @Inject
    private StylesheetLoader() {
    }

    public Stylesheet load(URL uRL) {
        return this.load(new UrlX(uRL, true));
    }

    public Stylesheet load(File file) {
        return this.load(file.toURL());
    }

    public Stylesheet load(UrlX urlX) {
        StylesheetSource stylesheetSource = this._loadedStylesheets.get(urlX);
        if (stylesheetSource == null) {
            StylesheetImpl stylesheetImpl = urlX.isFileProtocol() ? this.loadImpl(new File(urlX.asUrl())) : new StylesheetParser().parse(urlX);
            stylesheetSource = new StylesheetSource(urlX, stylesheetImpl);
            this._loadedStylesheets.put(urlX, stylesheetSource);
        }
        return stylesheetSource._stylesheet;
    }

    StylesheetImpl loadImpl(File file) {
        try {
            LoggerHelper.getLogger().debug((Object)"loading stylesheet {}", (Object)file.getCanonicalPath());
            StylesheetImpl stylesheetImpl = new StylesheetParser().parse(file);
            LoggerHelper.getLogger().debug((Object)"completed loading stylesheet {}", (Object)file.getCanonicalPath());
            return stylesheetImpl;
        }
        catch (Exception exception) {
            throw new RuntimeException("loading of stylesheet " + file.getCanonicalPath() + " failed.", exception);
        }
    }

    public void startStylesheetReloaderThread(TimeDuration timeDuration) {
        if (this._reloaderRunnable == null) {
            this._reloaderRunnable = new Runnable(){

                @Override
                public void run() {
                    for (StylesheetSource stylesheetSource : ListX.create(StylesheetLoader.this._loadedStylesheets.values())) {
                        stylesheetSource.reloadIfChanged();
                    }
                }
            };
            ((ThreadScheduler)this._injector.getInstance(ThreadScheduler.class)).scheduleRepeating("StyleSheetReloader", timeDuration, this._reloaderRunnable);
        }
    }

    public ReflectionTool getReflectionTool() {
        return this._reflectionTool;
    }

    class StylesheetSource {
        final Logger logger = LoggerHelper.getLogger();
        UrlX _url;
        long _lastModified;
        StylesheetImpl _stylesheet;
        File _file;

        private StylesheetSource(UrlX urlX, StylesheetImpl stylesheetImpl) {
            this._url = urlX;
            this._stylesheet = stylesheetImpl;
            if (this._url.isFileProtocol()) {
                this._file = new File(urlX.asUrl());
                this._lastModified = this._file.asFile().lastModified();
            }
        }

        boolean hasChanges() {
            if (this._url.isFileProtocol()) {
                return this._file.exists() && this._lastModified != this._file.asFile().lastModified();
            }
            return false;
        }

        void reloadIfChanged() {
            if (this.hasChanges()) {
                this.logger.debug((Object)"starting reload of {}", (Object)this._file.getCanonicalPath());
                this._lastModified = this._file.asFile().lastModified();
                try {
                    StylesheetImpl stylesheetImpl = StylesheetLoader.this.loadImpl(this._file);
                    this._stylesheet.resetStyles(stylesheetImpl.getStyles());
                }
                catch (Exception exception) {
                    LoggerHelper.getLogger().error((Object)"error reloading stylesheet {} will continue to use previous version", (Object)this._file.getCanonicalPath(), (Object)exception);
                }
                this.logger.debug((Object)"completed reload of {}", (Object)this._file.getCanonicalPath());
            }
        }
    }
}

