/*
 * Decompiled with CFR 0.152.
 */
package css;

import css.Stylesheet;
import css.component.ComponentWrapper;
import java.awt.Component;
import javax.swing.JComponent;
import net.model3.lang.ObjectX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public final class CssHelper {
    private static final Logger logger = LoggerHelper.getLogger();

    public static void addStyleClass(Component component, String string) {
        logger.trace((Object)"added style {} to {}", (Object)string, (Object)ObjectX.identityToString((Object)component));
        ComponentWrapper componentWrapper = ComponentWrapper.get(component);
        componentWrapper.addStyleClass(string);
    }

    public static Stylesheet getStylesheet(Component component) {
        Stylesheet stylesheet = null;
        if (component instanceof JComponent) {
            stylesheet = (Stylesheet)((JComponent)component).getClientProperty(Stylesheet.class);
        }
        if (stylesheet != null) {
            return stylesheet;
        }
        if (component.getParent() != null) {
            return CssHelper.getStylesheet(component.getParent());
        }
        return null;
    }

    public static void enableStyleClass(Component component, boolean bl, String string) {
        if (bl) {
            CssHelper.addStyleClass(component, string);
        } else {
            CssHelper.removeStyleClass(component, string);
        }
    }

    public static void removeStyleClass(Component component, String string) {
        ComponentWrapper componentWrapper = ComponentWrapper.get(component);
        if (componentWrapper.removeStyleClass(string)) {
            logger.trace((Object)"removed style {} to {}", (Object)string, (Object)ObjectX.identityToString((Object)component));
        }
    }
}

