/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.LinkedHashMap;
import java.util.Map;
import net.miginfocom.swing.MigLayout;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.swing.GuiHelper;
import net.model3x.swing.BeanListener;
import net.model3x.swing.M3ConstraintSet;

public class M3Layout
implements LayoutManager2 {
    private static final Logger logger = LoggerHelper.getLogger();
    MigLayout _layoutDelegate;
    final M3ConstraintSet _layoutConstraint;
    final M3ConstraintSet _rowConstraint;
    final M3ConstraintSet _columnConstraint;
    Container _container;
    Map<Component, Object[]> _componentToConstraintMappings = new LinkedHashMap<Component, Object[]>();

    public M3Layout() {
        this(null, null, null);
    }

    public M3Layout(String string) {
        this(string, null, null);
    }

    public M3Layout(String string, String string2, String string3) {
        BeanListener<M3ConstraintSet> beanListener = new BeanListener<M3ConstraintSet>(){

            @Override
            public void beanEvent(M3ConstraintSet m3ConstraintSet) {
                M3Layout.this.resetLayout();
            }
        };
        this._layoutConstraint = new M3ConstraintSet(string, beanListener);
        this._columnConstraint = new M3ConstraintSet(string2, beanListener);
        this._rowConstraint = new M3ConstraintSet(string3, beanListener);
        this._layoutDelegate = new MigLayout(string, string2, string3);
    }

    public M3Layout(String string, String string2) {
        this(string, string2, null);
    }

    public void setContainer(Container container) {
        if (this._container != container) {
            if (this._container != null) {
                logger.warn((Object)"multiple containers in layout manager {} and {}", (Object)this._container, (Object)container);
            }
            this._container = container;
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        this._componentToConstraintMappings.put(component, new Object[]{object});
        this._layoutDelegate.addLayoutComponent(component, object);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        this.setContainer(container);
        return this._layoutDelegate.getLayoutAlignmentX(container);
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        this.setContainer(container);
        return this._layoutDelegate.getLayoutAlignmentY(container);
    }

    @Override
    public void invalidateLayout(Container container) {
        this.setContainer(container);
        this._layoutDelegate.invalidateLayout(container);
    }

    @Override
    public void layoutContainer(Container container) {
        this.setContainer(container);
        this._layoutDelegate.layoutContainer(container);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        this.setContainer(container);
        return this._layoutDelegate.maximumLayoutSize(container);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        this.setContainer(container);
        return this._layoutDelegate.minimumLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        this.setContainer(container);
        return this._layoutDelegate.preferredLayoutSize(container);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this._layoutDelegate.removeLayoutComponent(component);
    }

    public void resetLayout() {
        this._layoutDelegate.setLayoutConstraints((Object)this._layoutConstraint.asString());
        this._layoutDelegate.setColumnConstraints((Object)this._columnConstraint.asString());
        this._layoutDelegate.setRowConstraints((Object)this._rowConstraint.asString());
        GuiHelper.doLayoutHack(this._container);
    }

    public void setComponentConstraint(Component component, String string) {
        this._componentToConstraintMappings.get((Object)component)[0] = string;
        this._layoutDelegate.setComponentConstraints(component, (Object)string);
        this.resetLayout();
    }

    public String getComponentConstraint(Component component) {
        Object[] objectArray = this._componentToConstraintMappings.get(component);
        if (objectArray != null && objectArray[0] instanceof String) {
            return (String)objectArray[0];
        }
        return null;
    }

    public void setColumnConstraints(String string) {
        this._columnConstraint.replaceConstraints(string);
    }

    public void setLayoutConstraints(String string) {
        this._layoutConstraint.replaceConstraints(string);
    }

    public void setRowConstraints(String string) {
        this._rowConstraint.replaceConstraints(string);
    }

    public String getRowConstraints() {
        return this._rowConstraint.asString();
    }

    public String getLayoutConstraints() {
        return this._layoutConstraint.asString();
    }

    public String getColumnConstraints() {
        return this._columnConstraint.asString();
    }
}

