/*
 * Decompiled with CFR 0.152.
 */
package net.model3.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.util.concurrent.ScheduledFuture;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.File;
import net.model3.xstream.ForgivingReflectionProvider;
import net.model3.xstream.M3XStreamer;

public class XmlSerializableConfig {
    private final transient Logger logger = LoggerHelper.getLogger();
    private transient long _configFileTimestamp;
    private transient File _configFile;
    private transient ScheduledFuture<?> _reloadConfigTask;

    public File getConfigFile() {
        return this._configFile;
    }

    public File getSampleConfigFile() {
        return new File(this.getConfigFile().getParent(), this.getConfigFile().getName() + ".sample");
    }

    public String asXml() {
        XStream xStream = this.createXStreamer();
        String string = xStream.toXML((Object)this);
        return string;
    }

    public void save() {
        this.getConfigFile().write(this.asXml());
        this.logger.info((Object)"config saved to {}", (Object)this.getConfigFile().getCanonicalPath());
    }

    public void saveSample(XmlSerializableConfig xmlSerializableConfig) {
        try {
            this.getSampleConfigFile().write(xmlSerializableConfig.asXml());
            this.logger.debug((Object)"sample config saved to {}", (Object)this.getSampleConfigFile().getCanonicalPath());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void reloadConfig() {
        if (this._configFile.exists() && this._configFile.getLastModified().inMillis() != this._configFileTimestamp) {
            this.load(this._configFile);
        }
    }

    public void load(File file) {
        this._configFile = file;
        if (this._configFile.exists()) {
            if (this._reloadConfigTask != null) {
                this._reloadConfigTask.cancel(true);
                this._reloadConfigTask = null;
            }
            this.logger.debug((Object)"loading config from {}", (Object)file.getCanonicalPath());
            String string = this.getConfigFile().readText();
            this.loadFromXmlImpl(string, this.getConfigFile().getCanonicalPath());
            this._configFileTimestamp = this._configFile.getLastModified().inMillis();
        } else {
            this.logger.info((Object)"config file {} not found creating a default config file");
            this.save();
        }
    }

    public void loadFromXml(String string) {
        this.loadFromXmlImpl(string, "raw-xml");
    }

    protected void loadFromXmlImpl(String string, String string2) {
        M3XStreamer.setContext(string2);
        XStream xStream = this.createXStreamer();
        xStream.fromXML(string, (Object)this);
        this.logger.trace((Object)"config loaded from = {}  using xml=\n{}", (Object)string2, (Object)string);
    }

    Object readResolve() {
        return this;
    }

    protected XStream createXStreamer() {
        M3XStreamer m3XStreamer = new M3XStreamer((ReflectionProvider)new ForgivingReflectionProvider(), (HierarchicalStreamDriver)new DomDriver());
        m3XStreamer.processAnnotations(this.getClass());
        return m3XStreamer;
    }
}

