/*
 * Decompiled with CFR 0.152.
 */
package net.model3.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import net.model3.lang.ByteSize;
import net.model3.lang.StringX;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.xstream.ForgivingReflectionProvider;
import net.model3.xstream.UnderscoreFieldMapper;

public class M3XStreamer
extends XStream {
    private static final Logger logger = LoggerHelper.getLogger();
    private static ThreadLocal<String> _context = new ThreadLocal();

    public static void setContext(String string) {
        _context.set(string);
    }

    public static String getContext() {
        if (_context.get() == null) {
            return "";
        }
        return _context.get();
    }

    public M3XStreamer(ReflectionProvider reflectionProvider) {
        this(reflectionProvider, (HierarchicalStreamDriver)new DomDriver());
    }

    public M3XStreamer() {
        this((ReflectionProvider)new ForgivingReflectionProvider(new JVM().bestReflectionProvider()), (HierarchicalStreamDriver)new DomDriver());
    }

    public M3XStreamer(HierarchicalStreamDriver hierarchicalStreamDriver) {
        this((ReflectionProvider)new ForgivingReflectionProvider(new JVM().bestReflectionProvider()), hierarchicalStreamDriver);
    }

    public M3XStreamer(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver) {
        super(reflectionProvider, hierarchicalStreamDriver);
        this.registerConverter((SingleValueConverter)new AbstractSingleValueConverter(){

            public boolean canConvert(Class clazz) {
                return clazz.equals(TimeDuration.class);
            }

            public Object fromString(String string) {
                if (StringX.isNotBlank(string)) {
                    return new TimeDuration(string);
                }
                return null;
            }

            public String toString(Object object) {
                if (object == null) {
                    return "";
                }
                return ((TimeDuration)object).asVerboseText();
            }
        });
        this.registerConverter((SingleValueConverter)new AbstractSingleValueConverter(){

            public boolean canConvert(Class clazz) {
                return clazz.equals(ByteSize.class);
            }

            public Object fromString(String string) {
                if (StringX.isNotBlank(string)) {
                    return new ByteSize(string);
                }
                return null;
            }

            public String toString(Object object) {
                if (object == null) {
                    return "";
                }
                return ((ByteSize)object).asVerboseText();
            }
        });
        this.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
    }

    public M3XStreamer(ReflectionProvider reflectionProvider, Mapper mapper, HierarchicalStreamDriver hierarchicalStreamDriver) {
        super(reflectionProvider, mapper, hierarchicalStreamDriver);
        this.registerConverter((SingleValueConverter)new /* invalid duplicate definition of identical inner class */);
        this.registerConverter((SingleValueConverter)new /* invalid duplicate definition of identical inner class */);
        this.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
    }

    protected MapperWrapper wrapMapper(MapperWrapper mapperWrapper) {
        return new UnderscoreFieldMapper((Mapper)mapperWrapper);
    }
}

