/*
 * Decompiled with CFR 0.152.
 */
package net.model3.xstream;

import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProviderWrapper;
import java.lang.reflect.Field;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class ForgivingReflectionProvider
extends ReflectionProviderWrapper {
    private static final Logger logger = LoggerHelper.getLogger();
    private transient Object _transient;
    private Field _transientField;

    public ForgivingReflectionProvider() {
        this((ReflectionProvider)new PureJavaReflectionProvider());
    }

    public ForgivingReflectionProvider(ReflectionProvider reflectionProvider) {
        super(reflectionProvider);
    }

    public Field getTransientField() {
        if (this._transientField == null) {
            this._transientField = this.getField(ForgivingReflectionProvider.class, "_transient");
        }
        return this._transientField;
    }

    public Class getFieldType(Object object, String string, Class clazz) {
        try {
            return super.getFieldType(object, string, clazz);
        }
        catch (ObjectAccessException objectAccessException) {
            logger.warn((Object)"{}.{} not found", (Object)object.getClass().getName(), (Object)string);
            return Object.class;
        }
    }

    public Field getField(Class clazz, String string) {
        try {
            return super.getField(clazz, string);
        }
        catch (ObjectAccessException objectAccessException) {
            return this.getTransientField();
        }
    }

    public boolean fieldDefinedInClass(String string, Class clazz) {
        boolean bl = super.fieldDefinedInClass(string, clazz);
        if (!bl) {
            return true;
        }
        return bl;
    }
}

