/*
 * Decompiled with CFR 0.152.
 */
package net.model3.util;

import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class XmlConfigurator {
    private static final Logger logger = LoggerHelper.getLogger(XmlConfigurator.class);
    private static final int PROP_KEY = 0;
    private static final int PROP_NEW_VALUE = 1;
    private static final int PROP_SAVED_VALUE = 2;
    private boolean useLog_ = true;
    private String[][] properties_ = new String[][]{{"javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl", null}, {"javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl", null}, {"javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl", null}};

    public void configure() {
        for (int i = 0; i < this.properties_.length; ++i) {
            String string = this.properties_[i][0];
            String string2 = this.properties_[i][1];
            this.properties_[i][2] = System.getProperty(string);
            if (this.useLog_) {
                logger.debug((Object)("configuring   " + string + "=" + string2));
            }
            System.setProperty(string, string2);
        }
    }

    public void restorePreviousConfiguration() {
        for (int i = 0; i < this.properties_.length; ++i) {
            String string = this.properties_[i][0];
            String string2 = this.properties_[i][2];
            if (this.useLog_) {
                logger.debug((Object)("restoring configuration   " + string + "=" + string2));
            }
            if (string2 == null) {
                System.getProperties().remove(string);
                continue;
            }
            System.setProperty(string, string2);
        }
    }

    public boolean isUseLog() {
        return this.useLog_;
    }

    public void setUseLog(boolean bl) {
        this.useLog_ = bl;
    }

    public XmlConfigurator() {
    }

    public XmlConfigurator(boolean bl) {
        this.useLog_ = bl;
    }
}

