/*
 * Decompiled with CFR 0.152.
 */
package net.model3.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.model3.collections.CollectionX;
import net.model3.collections.ListX;
import net.model3.io.BytesBuilder;
import net.model3.lang.ClassX;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.util.Crypto;

public class Versioning {
    private static final String VersioningFile = "META-INF/version.properties";
    private static final Logger logger = LoggerHelper.getLogger();
    private static final String INDENT = "   ";
    private static final Map<Class, Versioning> versionCache_ = new HashMap<Class, Versioning>();
    private Properties properties_ = new Properties();
    private Class clazz_;
    private String versionDotPropsAsString_;
    private URL versionDotPropsUrl_;
    private String classpathEntry_;

    public Versioning() {
    }

    private Versioning(URL uRL) throws Exception {
        this.versionDotPropsUrl_ = uRL;
        this.init();
    }

    private Versioning(Class clazz) {
        try {
            String string = clazz.getName().replace('.', '/') + ".class";
            String string2 = clazz.getClassLoader().getResource(string).toExternalForm();
            URL uRL = new URL(string2.substring(0, string2.length() - string.length()));
            this.versionDotPropsUrl_ = new URL(uRL.toExternalForm() + VersioningFile);
        }
        catch (Exception exception) {
            logger.warn((Object)"unable to load versioning for {}", (Object)clazz.getName());
        }
    }

    private void init() throws Exception {
        String string;
        InputStream inputStream = this.versionDotPropsUrl_.openStream();
        BytesBuilder bytesBuilder = new BytesBuilder(inputStream);
        this.properties_.load(new ByteArrayInputStream(bytesBuilder.asBytes()));
        this.classpathEntry_ = ClassX.getJarOrDirectory(this.versionDotPropsUrl_, VersioningFile);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytesBuilder.asBytes())));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("svn_info") || string.startsWith("svn_uncommitted_files")) continue;
            if (string.startsWith("#")) {
                string = string.substring(1);
            }
            stringBuilder.append(INDENT);
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        this.versionDotPropsAsString_ = stringBuilder.toString();
        inputStream.close();
    }

    public String getVersion() {
        return this.properties_.getProperty("version_number", "unknown");
    }

    public String getBuildDate() {
        return this.properties_.getProperty("build_date", "unknown");
    }

    public String getBuildMachine() {
        return this.properties_.getProperty("build_machine", "unknown");
    }

    public String getSvnRevisionNumber() {
        return this.properties_.getProperty("svn_revision", "unknown");
    }

    public String getSvnUrl() {
        return this.properties_.getProperty("svn_url", "unknown");
    }

    public String getSvnInfo() {
        return this.getHexDecodedProperty("svn_info");
    }

    private String getHexDecodedProperty(String string) {
        String string2 = this.properties_.getProperty(string);
        if (string2 == null) {
            return "property " + string + " not found.";
        }
        String string3 = null;
        try {
            if (string2 != null) {
                string3 = new String(Crypto.hexStringToByteArray(string2));
            }
        }
        catch (RuntimeException runtimeException) {
            string3 = "error decoding property " + string;
            logger.error((Object)string3, (Object)runtimeException);
        }
        return string3;
    }

    public String getInfoString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("versioning info");
        stringBuilder.append("\n");
        stringBuilder.append(INDENT);
        stringBuilder.append("classpathEntry =" + this.classpathEntry_);
        stringBuilder.append("\n");
        stringBuilder.append(INDENT);
        stringBuilder.append("versionDotPropsUrl = " + this.versionDotPropsUrl_);
        stringBuilder.append("\n");
        if (this.versionDotPropsAsString_ == null) {
            stringBuilder.append(INDENT);
            stringBuilder.append("no additional version info");
        } else {
            stringBuilder.append(this.versionDotPropsAsString_);
        }
        return stringBuilder.toString();
    }

    public void logInfo() {
        logger.info((Object)this.getInfoString());
    }

    public void outputInfo(PrintWriter printWriter) {
        printWriter.println(this.getInfoString());
        printWriter.println();
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public static void logAllVersioningFound() {
        Versioning.logAllVersioningFound(Thread.currentThread().getContextClassLoader());
    }

    public static void logAllVersioningFound(ClassLoader classLoader) {
        boolean bl = false;
        for (Versioning versioning : Versioning.getAllVersioningResources(Thread.currentThread().getContextClassLoader())) {
            versioning.logInfo();
            bl = true;
        }
        if (!bl) {
            logger.info((Object)"no versioning info found");
        }
    }

    public static List<Versioning> getAllVersioningResources(ClassLoader classLoader) {
        try {
            List<Versioning> list = ListX.create();
            for (URL uRL : CollectionX.collect(classLoader.getResources(VersioningFile))) {
                try {
                    list.add(new Versioning(uRL));
                }
                catch (Exception exception) {
                    logger.warn((Object)"unable to load versioning info from {}", (Object)uRL, (Object)exception);
                }
            }
            return list;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public static final Versioning getVersioning(Class clazz) {
        Versioning versioning = versionCache_.get(clazz);
        if (versioning == null) {
            versioning = new Versioning(clazz);
            versionCache_.put(clazz, versioning);
        }
        return versioning;
    }
}

