/*
 * Decompiled with CFR 0.152.
 */
package net.model3.util;

import com.google.inject.Singleton;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.model3.chrono.DateOnly;
import net.model3.chrono.DateTime;
import net.model3.chrono.Month;
import net.model3.chrono.TimeOnly;

@Singleton
public class UberDateParser {
    private static final String SNIPPET_DATE_SEP = "[-/]";
    private static final String SNIPPET_MONTH = "([0-9]{1,2})";
    private static final String SNIPPET_4DIGIT_YEAR = "([0-9]{4})";
    private static final String SNIPPET_2DIGIT_YEAR = "([0-9]{2})";
    private static final String SNIPPET_DAY = "([0-9]{1,2})";
    public static final Pattern PATTERN_YMD = Pattern.compile("([0-9]{2})[-/]([0-9]{1,2})[-/]([0-9]{1,2})");
    public static final Pattern PATTERN_MDY = Pattern.compile("([0-9]{1,2})[-/]([0-9]{1,2})[-/]([0-9]{2})");
    public static final Pattern PATTERN_CYMD = Pattern.compile("([0-9]{4})[-/]([0-9]{1,2})[-/]([0-9]{1,2})");
    public static final Pattern PATTERN_MDCY = Pattern.compile("([0-9]{1,2})[-/]([0-9]{1,2})[-/]([0-9]{4})");
    private static final Pattern PATTERN_TIME = Pattern.compile("([0-9]{1,2}):([0-9]{1,2})(?::([0-9][0-9]))?");
    private static final String[] MONTHS = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static final Pattern PATTERN_MONTH_TEXT;
    private static final Pattern PATTERN_MONTH_SUFFIX;
    boolean _throwExceptionOnParseFailure = false;
    Pattern[] _datePatterns = new Pattern[]{PATTERN_MDCY, PATTERN_CYMD, PATTERN_MDY};

    public void setThrowExceptionOnParseFailure(boolean bl) {
        this._throwExceptionOnParseFailure = bl;
    }

    public TimeOnly parseTimeOnly(String string) {
        DateHolder dateHolder = this.parseToDateHolder(string);
        return dateHolder.asTimeOnly();
    }

    public DateOnly parseDateOnly(String string) {
        DateHolder dateHolder = this.parseToDateHolder(string);
        return dateHolder.asDateOnly();
    }

    public DateTime parseDateTime(String string) {
        DateHolder dateHolder = this.parseToDateHolder(string);
        return dateHolder.asDateTime();
    }

    public DateHolder parseToDateHolder(String string) {
        String string2 = " " + string.toLowerCase() + " ";
        DateHolder dateHolder = new DateHolder(string);
        this.parseForDatePart(dateHolder, string2);
        this.parseForTimePart(dateHolder, string2);
        return dateHolder;
    }

    public Pattern[] getDatePatterns() {
        return this._datePatterns;
    }

    public void setDatePatterns(Pattern[] patternArray) {
        this._datePatterns = patternArray;
    }

    void parseForDatePart(DateHolder dateHolder, String string) {
        Object object = this._datePatterns;
        int n = ((Pattern[])object).length;
        for (int i = 0; i < n; ++i) {
            Pattern pattern = object[i];
            this.checkDatePattern(dateHolder, pattern, string);
            if (dateHolder._year != null) break;
        }
        if (dateHolder._year == null && ((Matcher)(object = PATTERN_MONTH_TEXT.matcher(string))).find()) {
            dateHolder._month = this.getMonthIndex(((Matcher)object).group());
            String string2 = string.substring(((Matcher)object).end());
            Matcher matcher = PATTERN_MONTH_SUFFIX.matcher(string2);
            if (matcher.find()) {
                dateHolder._day = Integer.parseInt(matcher.group(1));
                dateHolder._year = Integer.parseInt(matcher.group(2));
            }
        }
    }

    void checkDatePattern(DateHolder dateHolder, Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find() && UberDateParser.isProperStart(matcher, string) && UberDateParser.isProperEnd(matcher, string)) {
            if (pattern == PATTERN_CYMD) {
                dateHolder._year = Integer.parseInt(matcher.group(1));
                dateHolder._month = Month.fromNumber(Integer.parseInt(matcher.group(2)));
                dateHolder._day = Integer.parseInt(matcher.group(3));
            } else if (pattern == PATTERN_MDCY) {
                dateHolder._month = Month.fromNumber(Integer.parseInt(matcher.group(1)));
                dateHolder._day = Integer.parseInt(matcher.group(2));
                dateHolder._year = Integer.parseInt(matcher.group(3));
            } else if (pattern == PATTERN_YMD) {
                dateHolder._year = this.fix2DigitYear(Integer.parseInt(matcher.group(1)));
                dateHolder._month = Month.fromNumber(Integer.parseInt(matcher.group(2)));
                dateHolder._day = Integer.parseInt(matcher.group(3));
            } else if (pattern == PATTERN_MDY) {
                dateHolder._month = Month.fromNumber(Integer.parseInt(matcher.group(1)));
                dateHolder._day = Integer.parseInt(matcher.group(2));
                dateHolder._year = this.fix2DigitYear(Integer.parseInt(matcher.group(3)));
            } else {
                throw new RuntimeException("unknown date pattern");
            }
            if (dateHolder._month == null) {
                dateHolder._year = null;
                dateHolder._day = null;
            }
        }
    }

    private Integer fix2DigitYear(int n) {
        if (n < 50) {
            return 2000 + n;
        }
        return 1900 + n;
    }

    void parseForTimePart(DateHolder dateHolder, String string) {
        this.checkForMeridian(dateHolder, string);
        Matcher matcher = PATTERN_TIME.matcher(string);
        if (matcher.find() && UberDateParser.isProperStart(matcher, string) && UberDateParser.isProperEnd(matcher, string)) {
            dateHolder._hour = Integer.parseInt(matcher.group(1));
            dateHolder._minute = Integer.parseInt(matcher.group(2));
            if (matcher.group(3) != null) {
                dateHolder._second = Integer.parseInt(matcher.group(3));
            }
        }
    }

    void checkForMeridian(DateHolder dateHolder, String string) {
        if (string.indexOf("am") >= 0) {
            dateHolder._pm = false;
        }
        if (string.indexOf("pm") >= 0) {
            dateHolder._pm = true;
        }
    }

    Month getMonthIndex(String string) {
        for (int i = 0; i < MONTHS.length; ++i) {
            if (!MONTHS[i].equalsIgnoreCase(string)) continue;
            return Month.values()[i];
        }
        return null;
    }

    static boolean isProperStart(Matcher matcher, String string) {
        return !Character.isDigit(string.charAt(matcher.start() - 1));
    }

    static boolean isProperEnd(Matcher matcher, String string) {
        return matcher.end() >= string.length() || !Character.isDigit(string.charAt(matcher.end()));
    }

    static {
        PATTERN_MONTH_SUFFIX = Pattern.compile("[a-z]*[ ]*[,]?[ ]*([0-9]{1,2})[ ]*[ ,][ ]*([0-9]{4})");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : MONTHS) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("(?:");
            stringBuilder.append(string);
            stringBuilder.append(")");
        }
        PATTERN_MONTH_TEXT = Pattern.compile("(" + stringBuilder + ")");
    }

    public class DateHolder {
        String _inputString;
        Integer _year;
        Month _month;
        Integer _day;
        Integer _hour;
        Integer _minute;
        Integer _second = 0;
        Boolean _pm;

        DateHolder(String string) {
            this._inputString = string;
        }

        public boolean hasValidTimeOnlyFields() {
            return this._hour != null && this._minute != null;
        }

        public boolean hasValidDateOnlyFields() {
            return this._year != null && this._month != null && this._day != null;
        }

        public TimeOnly asTimeOnly() {
            if (this.hasValidTimeOnlyFields()) {
                return new TimeOnly(this.getMilitaryHour(), this._minute, this.getSecond());
            }
            return null;
        }

        public DateOnly asDateOnly() {
            if (this.hasValidDateOnlyFields()) {
                return new DateOnly((int)this._year, this._month, (int)this._day);
            }
            if (UberDateParser.this._throwExceptionOnParseFailure) {
                throw new RuntimeException("invalid date");
            }
            return null;
        }

        public int getMilitaryHour() {
            if (this._pm != null) {
                if (!this._pm.booleanValue()) {
                    if (this._hour == 12) {
                        return 0;
                    }
                } else if (this._hour < 12) {
                    return this._hour + 12;
                }
            }
            return this._hour;
        }

        public DateTime asDateTime() {
            if (this.hasValidDateOnlyFields() && this.hasValidTimeOnlyFields()) {
                return new DateTime((int)this._year, this._month, (int)this._day, this.getMilitaryHour(), (int)this._minute, (int)this.getSecond());
            }
            if (UberDateParser.this._throwExceptionOnParseFailure) {
                throw new RuntimeException("invalid date and time");
            }
            return null;
        }

        public String getInputString() {
            return this._inputString;
        }

        public Integer getYear() {
            return this._year;
        }

        public Month getMonth() {
            return this._month;
        }

        public Integer getDay() {
            return this._day;
        }

        public Integer getHour() {
            return this._hour;
        }

        public Integer getMinute() {
            return this._minute;
        }

        public Integer getSecond() {
            if (this._second == 0) {
                this._second = 0;
            }
            return this._second;
        }

        public Boolean getPm() {
            return this._pm;
        }
    }
}

