/*
 * Decompiled with CFR 0.152.
 */
package net.model3.util;

import java.util.List;
import java.util.Map;
import net.model3.collections.ListX;
import net.model3.collections.MapX;

public class TypeFactory<TReturnedType, TSourceType> {
    List<Handler<TReturnedType, TSourceType>> _handlers = ListX.create();
    Map<TSourceType, Handler<TReturnedType, TSourceType>> _resolvedHandlers = MapX.create();
    boolean _throwNotFoundException = false;

    public void registerHandler(Handler<TReturnedType, TSourceType> handler) {
        this._handlers.add(handler);
    }

    public void setResolution(TSourceType TSourceType, Handler<TReturnedType, TSourceType> handler) {
        this._resolvedHandlers.put(TSourceType, handler);
    }

    public TReturnedType getInstance(TSourceType TSourceType) {
        Handler<TReturnedType, TSourceType> handler = this._resolvedHandlers.get(TSourceType);
        if (handler == null) {
            for (Handler<TReturnedType, TSourceType> handler2 : this._handlers) {
                if (!handler2.canHandleSource(TSourceType)) continue;
                handler = handler2;
                this.setResolution(TSourceType, handler2);
                break;
            }
        }
        if (handler == null && this._throwNotFoundException) {
            throw new RuntimeException("unable to find handler for " + TSourceType);
        }
        if (handler != null) {
            return handler.createInstance(TSourceType);
        }
        return null;
    }

    public void setThrowNotFoundException(boolean bl) {
        this._throwNotFoundException = bl;
    }

    public static interface Handler<TReturnedType, TSourceType> {
        public boolean canHandleSource(TSourceType var1);

        public TReturnedType createInstance(TSourceType var1);
    }
}

