/*
 * Decompiled with CFR 0.152.
 */
package net.model3.util;

import java.util.ArrayList;

public class Tokenizer {
    private boolean includeEmptyTokens_;
    private boolean reachedEndOfText_ = false;
    private String delimiters_;
    private String text_;
    private int index_ = 0;
    private int currentTokenStart_;
    private int currentTokenEnd_;
    private String currentToken_;

    public Tokenizer(String string) {
        this(string, " \t\n\r\f");
    }

    public Tokenizer(String string, String string2) {
        this(string, string2, false);
    }

    public Tokenizer(String string, String string2, boolean bl) {
        this.text_ = string;
        this.delimiters_ = string2;
        this.includeEmptyTokens_ = bl;
    }

    public boolean isSeparator(char c) {
        return this.delimiters_.indexOf(c) >= 0;
    }

    public String nextToken() {
        if (this.next()) {
            return this.currentToken();
        }
        return null;
    }

    public boolean next() {
        block9: {
            this.currentToken_ = null;
            if (this.reachedEndOfText_) {
                return false;
            }
            if (this.index_ == this.text_.length()) {
                this.reachedEndOfText_ = true;
                if (this.includeEmptyTokens_) {
                    this.currentToken_ = "";
                    this.currentTokenStart_ = this.currentTokenEnd_ = this.text_.length();
                    return true;
                }
                return false;
            }
            boolean bl = false;
            this.currentTokenStart_ = this.index_;
            do {
                char c;
                if (this.isSeparator(c = this.text_.charAt(this.index_))) {
                    if (this.includeEmptyTokens_ || bl) break block9;
                    this.currentTokenStart_ = this.index_ + 1;
                } else if (this.includeEmptyTokens_ || !Character.isWhitespace(c)) {
                    bl = true;
                }
                ++this.index_;
            } while (this.index_ != this.text_.length());
            if (!this.includeEmptyTokens_ && !bl) {
                return false;
            }
            this.reachedEndOfText_ = true;
        }
        this.currentTokenEnd_ = this.index_ - 1;
        this.currentToken_ = this.text_.substring(this.currentTokenStart_, this.currentTokenEnd_ + 1);
        if (this.includeEmptyTokens_) {
            ++this.index_;
        }
        return true;
    }

    public String currentToken() {
        return this.currentToken_;
    }

    public String[] getAllTokens() {
        return this.getAllTokens(false);
    }

    public String[] getAllTokens(boolean bl) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.currentToken() != null) {
            string = this.currentToken();
            arrayList.add(string);
        }
        while (this.next()) {
            string = this.currentToken();
            if (bl) {
                string = string.trim();
            }
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public int currentTokenStart() {
        return this.currentTokenStart_;
    }

    public int currentTokenEnd() {
        return this.currentTokenEnd_;
    }
}

