/*
 * Decompiled with CFR 0.152.
 */
package net.model3.util;

import com.thoughtworks.xstream.core.util.Base64Encoder;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.util.Crypto;

public class PassphraseCrypto {
    private static final Logger logger = LoggerHelper.getLogger();
    public static final StringEncoder ENCODER_BASE64 = new StringEncoder(){
        private Base64Encoder _encoder = new Base64Encoder();

        @Override
        public byte[] decode(String string) {
            return this._encoder.decode(string);
        }

        @Override
        public String encode(byte[] byArray) {
            return this._encoder.encode(byArray);
        }
    };
    public static final StringEncoder ENCODER_HEX_STRING = new StringEncoder(){

        @Override
        public byte[] decode(String string) {
            return Crypto.hexStringToByteArray(string);
        }

        @Override
        public String encode(byte[] byArray) {
            return Crypto.byteArrayToHexString(byArray);
        }
    };
    private String _passphrase;
    private StringEncoder _encoder;

    public PassphraseCrypto(String string, StringEncoder stringEncoder) {
        this._encoder = stringEncoder;
        this._passphrase = string;
    }

    public byte[] encryptToBytes(byte[] byArray) {
        return Crypto.encrypt(this._passphrase, byArray);
    }

    public String encryptToString(byte[] byArray) {
        return this._encoder.encode(this.encryptToBytes(byArray));
    }

    public byte[] encryptToBytes(String string) {
        return Crypto.encrypt(this._passphrase, string.getBytes());
    }

    public String encryptToString(String string) {
        return this._encoder.encode(this.encryptToBytes(string.getBytes()));
    }

    public byte[] decryptToBytes(byte[] byArray) {
        return Crypto.decrypt(this._passphrase, byArray);
    }

    public String decryptToString(byte[] byArray) {
        return new String(this.decryptToBytes(byArray));
    }

    public byte[] decryptToBytes(String string) {
        byte[] byArray = this._encoder.decode(string);
        return this.decryptToBytes(byArray);
    }

    public String decryptToString(String string) {
        byte[] byArray = this._encoder.decode(string);
        return this.decryptToString(byArray);
    }

    public static interface StringEncoder {
        public String encode(byte[] var1);

        public byte[] decode(String var1);
    }
}

