/*
 * Decompiled with CFR 0.152.
 */
package net.model3.util;

import java.io.File;
import net.model3.lang.StringX;
import net.model3.lang.ThrowableX;
import net.model3.logging.LoggerHelper;
import net.model3.logging.SimpleLoggingConfigurator;
import net.model3.net.EmailMessage;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class LoggedTransactionTemplate {
    private static final net.model3.logging.Logger logger = LoggerHelper.getLogger();
    private boolean errors_ = false;
    private net.model3.newfile.File uniqueLogFile_;
    private Runnable transaction_;
    private EmailMessage emailMessageTemplate_;
    private Throwable exception_;
    private Layout layout_ = new SimpleLoggingConfigurator(null).getDefaultLayout();

    public void onError() {
        EmailMessage emailMessage = this.emailMessageTemplate_.clone();
        if (StringX.isBlank(emailMessage.getSubject())) {
            emailMessage.setSubject("error processing transaction");
        }
        if (this.getUniqueLogFile() != null) {
            emailMessage.addAttachment(this.getUniqueLogFile());
        }
        if (this.exception_ != null) {
            emailMessage.setBody(emailMessage.getBody() + "\n\n\n" + ThrowableX.getStackTrace(this.exception_));
        }
        emailMessage.send();
    }

    public void execute() {
        Appender appender = null;
        try {
            try {
                appender = this.createAppender();
                ((Logger)logger.getRoot().getDelegate()).addAppender(appender);
            }
            catch (Throwable throwable) {
                this.errors_ = true;
                this.exception_ = throwable;
                logger.error((Object)"error setting up to call runImpl()", (Object)throwable);
            }
            try {
                if (!this.errors_) {
                    this.transaction_.run();
                }
            }
            catch (Throwable throwable) {
                this.errors_ = true;
                this.exception_ = throwable;
                logger.error((Object)"throwable in runImpl()", (Object)throwable);
            }
        }
        finally {
            ((Logger)logger.getRoot().getDelegate()).removeAppender(appender);
            try {
                if (appender != null) {
                    appender.close();
                }
            }
            catch (Exception exception) {}
        }
        if (this.errors_) {
            this.onError();
        }
    }

    protected Appender createAppender() {
        final Thread thread = Thread.currentThread();
        FileAppender fileAppender = new FileAppender(){

            public synchronized void doAppend(LoggingEvent loggingEvent) {
                if (Thread.currentThread() == thread) {
                    if (loggingEvent.getLevel().toInt() >= 30000) {
                        LoggedTransactionTemplate.this.errors_ = true;
                    }
                    super.doAppend(loggingEvent);
                }
            }
        };
        fileAppender.setFile(this.getUniqueLogFile().getCanonicalPath());
        fileAppender.setAppend(false);
        fileAppender.setName("LoggedTransactionTemplate-appender-" + thread.getId());
        fileAppender.setLayout(this.layout_);
        fileAppender.activateOptions();
        return fileAppender;
    }

    public void setLayout(Layout layout) {
        this.layout_ = layout;
    }

    public boolean isErrors() {
        return this.errors_;
    }

    public void setUniqueLogFile(net.model3.newfile.File file) {
        this.uniqueLogFile_ = file;
    }

    public net.model3.newfile.File getUniqueLogFile() {
        if (this.uniqueLogFile_ == null) {
            try {
                this.uniqueLogFile_ = new net.model3.newfile.File(File.createTempFile("LoggedTransactionTemplate", ".log"));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.uniqueLogFile_;
    }

    public void setTransaction(Runnable runnable) {
        this.transaction_ = runnable;
    }

    public void setEmailMessageTemplate(EmailMessage emailMessage) {
        this.emailMessageTemplate_ = emailMessage;
    }
}

