/*
 * Decompiled with CFR 0.152.
 */
package net.model3.util;

import com.thoughtworks.xstream.core.util.Base64Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class Crypto {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final byte[] SALT = new byte[]{-86, -69, -52, -35, 34, 68, -85, 18};
    private static final int ITERATIONS = 10;
    private static final String CIPHER_NAME = "PBEWithMD5AndDES";

    public static String decrypt(String string, String string2) {
        byte[] byArray = Crypto.hexStringToByteArray(string2);
        byArray = Crypto.decrypt(string, byArray);
        return new String(byArray);
    }

    public static byte[] decrypt(String string, byte[] byArray) {
        Cipher cipher = Crypto.getCipher(string, 2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(new CipherInputStream(byteArrayInputStream, cipher));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = dataInputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
        }
        catch (IOException iOException) {
            logger.error((Object)"IOError", (Object)iOException);
            throw ExceptionPropagator.wrap(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static Cipher getCipher(String string, int n) {
        return Crypto.computePBECipher(string, SALT, 10, CIPHER_NAME, n);
    }

    public static String encrypt(String string, String string2) {
        byte[] byArray = Crypto.encrypt(string, string2.getBytes());
        return Crypto.byteArrayToHexString(byArray);
    }

    public static byte[] encrypt(String string, byte[] byArray) {
        Cipher cipher = Crypto.getCipher(string, 1);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher);
        try {
            cipherOutputStream.write(byArray);
            cipherOutputStream.flush();
            cipherOutputStream.close();
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap(iOException);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    protected static Cipher computePBECipher(String string, byte[] byArray, int n, String string2, int n2) {
        try {
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string2);
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            Cipher cipher = Cipher.getInstance(string2);
            cipher.init(n2, (Key)secretKey, pBEParameterSpec);
            return cipher;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public static byte[] hexStringToByteArray(String string) {
        int n = string.length();
        if (n % 2 != 0) {
            throw new RuntimeException("string " + string + " not an even number of digits");
        }
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < byArray.length; ++i) {
            char c = Character.toLowerCase(string.charAt(i * 2));
            char c2 = Character.toLowerCase(string.charAt(i * 2 + 1));
            try {
                int n2 = Crypto.hexcharToInt(c);
                int n3 = Crypto.hexcharToInt(c2);
                byArray[i] = (byte)(n2 * 16 + n3);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeException("error in hex string \"" + string + "\" " + runtimeException.getMessage());
            }
        }
        return byArray;
    }

    public static String byteArrayToHexString(String string) {
        return Crypto.byteArrayToHexString(string.getBytes());
    }

    public static String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i] & 0xFF);
            switch (string.length()) {
                case 1: {
                    string = "0" + string;
                    break;
                }
                case 0: {
                    string = "00";
                }
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "WE_EAT_125_CHEESE";
        String string2 = "1234567890";
        Base64Encoder base64Encoder = new Base64Encoder();
        String string3 = base64Encoder.encode(Crypto.encrypt(string, string2.getBytes()));
        System.out.println(string3);
    }

    private static int hexcharToInt(char c) {
        if (Character.isDigit(c)) {
            return c - 48;
        }
        if ((c = Character.toLowerCase(c)) >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        throw new RuntimeException(c + " is not a hex digit");
    }

    public static byte[] calculateMd5(byte[] byArray) {
        return Crypto.calculateChecksum("MD5", byArray);
    }

    public static byte[] calculateSha(byte[] byArray) {
        return Crypto.calculateChecksum("SHA", byArray);
    }

    public static byte[] calculateChecksum(String string, byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            return messageDigest.digest(byArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

