/*
 * Decompiled with CFR 0.152.
 */
package net.model3.util;

public class Base64 {
    private static final char[] intToBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char[] intToAltBase64 = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', ',', '-', '.', ':', ';', '<', '>', '@', '[', ']', '^', '`', '_', '{', '|', '}', '~', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '?'};
    private static final byte[] base64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final byte[] altBase64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, -1, 62, 9, 10, 11, -1, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 12, 13, 14, -1, 15, 63, 16, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17, -1, 18, 19, 21, 20, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 22, 23, 24, 25};

    public static String byteArrayToBase64(byte[] byArray) {
        return Base64.byteArrayToBase64(byArray, false);
    }

    private static String byteArrayToBase64(byte[] byArray, boolean bl) {
        int n;
        int n2;
        int n3 = byArray.length;
        int n4 = n3 / 3;
        int n5 = n3 - 3 * n4;
        int n6 = 4 * ((n3 + 2) / 3);
        StringBuffer stringBuffer = new StringBuffer(n6);
        char[] cArray = bl ? intToAltBase64 : intToBase64;
        int n7 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            n = byArray[n7++] & 0xFF;
            int n8 = byArray[n7++] & 0xFF;
            int n9 = byArray[n7++] & 0xFF;
            stringBuffer.append(cArray[n >> 2]);
            stringBuffer.append(cArray[n << 4 & 0x3F | n8 >> 4]);
            stringBuffer.append(cArray[n8 << 2 & 0x3F | n9 >> 6]);
            stringBuffer.append(cArray[n9 & 0x3F]);
        }
        if (n5 != 0) {
            n2 = byArray[n7++] & 0xFF;
            stringBuffer.append(cArray[n2 >> 2]);
            if (n5 == 1) {
                stringBuffer.append(cArray[n2 << 4 & 0x3F]);
                stringBuffer.append("==");
            } else {
                n = byArray[n7++] & 0xFF;
                stringBuffer.append(cArray[n2 << 4 & 0x3F | n >> 4]);
                stringBuffer.append(cArray[n << 2 & 0x3F]);
                stringBuffer.append('=');
            }
        }
        return stringBuffer.toString();
    }

    public static byte[] base64ToByteArray(String string) {
        return Base64.base64ToByteArray(string, false);
    }

    static byte[] altBase64ToByteArray(String string) {
        return Base64.base64ToByteArray(string, true);
    }

    private static byte[] base64ToByteArray(String string, boolean bl) {
        int n;
        int n2;
        int n3;
        byte[] byArray = bl ? altBase64ToInt : base64ToInt;
        int n4 = string.length();
        int n5 = n4 / 4;
        if (4 * n5 != n4) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int n6 = 0;
        int n7 = n5;
        if (n4 != 0) {
            if (string.charAt(n4 - 1) == '=') {
                ++n6;
                --n7;
            }
            if (string.charAt(n4 - 2) == '=') {
                ++n6;
            }
        }
        byte[] byArray2 = new byte[3 * n5 - n6];
        int n8 = 0;
        int n9 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            n2 = Base64.base64toInt(string.charAt(n8++), byArray);
            n = Base64.base64toInt(string.charAt(n8++), byArray);
            int n10 = Base64.base64toInt(string.charAt(n8++), byArray);
            int n11 = Base64.base64toInt(string.charAt(n8++), byArray);
            byArray2[n9++] = (byte)(n2 << 2 | n >> 4);
            byArray2[n9++] = (byte)(n << 4 | n10 >> 2);
            byArray2[n9++] = (byte)(n10 << 6 | n11);
        }
        if (n6 != 0) {
            n3 = Base64.base64toInt(string.charAt(n8++), byArray);
            n2 = Base64.base64toInt(string.charAt(n8++), byArray);
            byArray2[n9++] = (byte)(n3 << 2 | n2 >> 4);
            if (n6 == 1) {
                n = Base64.base64toInt(string.charAt(n8++), byArray);
                byArray2[n9++] = (byte)(n2 << 4 | n >> 2);
            }
        }
        return byArray2;
    }

    private static int base64toInt(char c, byte[] byArray) {
        byte by = byArray[c];
        if (by < 0) {
            throw new IllegalArgumentException("Illegal character " + c);
        }
        return by;
    }
}

