/*
 * Decompiled with CFR 0.152.
 */
package net.model3.transaction;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.util.concurrent.Callable;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.transaction.Transaction;
import net.model3.transaction.TransactionInternal;
import net.model3.util.UidGenerator;

@Singleton
public class TransactionManager {
    static ThreadLocal<TransactionInternal> _transactions = new ThreadLocal();
    Logger logger = LoggerHelper.getLogger();
    @Inject
    Injector _injector;
    @Inject
    UidGenerator _uidGenerator;

    @Inject
    protected TransactionManager() {
    }

    public <T> T run(Callable<T> callable) {
        return this.run(callable, null);
    }

    public <T> T run(Callable<T> callable, Transaction.Listener listener) {
        TransactionInternal transactionInternal = _transactions.get();
        TransactionInternal transactionInternal2 = (TransactionInternal)this._injector.getInstance(TransactionInternal.class);
        try {
            _transactions.set(transactionInternal2);
            if (listener != null) {
                transactionInternal2.events().addListener(listener);
            }
            transactionInternal2.start();
            T t = callable.call();
            transactionInternal2.commit();
            T t2 = t;
            return t2;
        }
        catch (Throwable throwable) {
            try {
                transactionInternal2.rollback(throwable);
            }
            catch (Exception exception) {
                this.logger.error((Object)"error rolling back transaction", (Object)exception);
            }
            throw ExceptionPropagator.throwUnchecked(throwable);
        }
        finally {
            try {
                transactionInternal2.finally_();
            }
            catch (Exception exception) {
                this.logger.error((Object)"error in transaction.finally", (Object)exception);
            }
            _transactions.set(transactionInternal);
        }
    }

    public static Transaction getTransaction() {
        return _transactions.get();
    }

    public static String getTransactionUid() {
        Transaction transaction = TransactionManager.getTransaction();
        if (transaction != null) {
            return transaction.uid();
        }
        return null;
    }
}

