/*
 * Decompiled with CFR 0.152.
 */
package net.model3.transaction;

import java.util.Map;
import net.model3.collections.MapX;
import net.model3.lang.Visitor;
import net.model3.swing.EventManager;
import net.model3.transaction.Transaction;
import net.model3.transaction.TransactionInternal;

public class TransactionImpl
implements TransactionInternal {
    final EventManager<Transaction.Listener> _events = EventManager.create();
    final TransactionInternal _parent;
    final String _uid;
    final Map<String, Object> _attributes = MapX.create();

    public TransactionImpl(TransactionInternal transactionInternal, String string) {
        this._parent = transactionInternal;
        this._uid = string;
    }

    @Override
    public Transaction parent() {
        return this._parent;
    }

    @Override
    public EventManager<Transaction.Listener> events() {
        return this._events;
    }

    @Override
    public String uid() {
        return this._uid;
    }

    @Override
    public void setAttribute(String string, Object object) {
        this._attributes.put(string, object);
    }

    @Override
    public <T> T getAttribute(String string) {
        return (T)this._attributes.get(string);
    }

    @Override
    public void commit() {
        this._events.safeDispatch(new Visitor<Transaction.Listener>(){

            @Override
            public void visit(Transaction.Listener listener) {
                listener.commit(TransactionImpl.this);
            }
        });
    }

    @Override
    public void rollback(final Throwable throwable) {
        this._events.safeDispatch(new Visitor<Transaction.Listener>(){

            @Override
            public void visit(Transaction.Listener listener) {
                listener.rollback(TransactionImpl.this, throwable);
            }
        });
    }

    @Override
    public void finally_() {
        this._events.safeDispatch(new Visitor<Transaction.Listener>(){

            @Override
            public void visit(Transaction.Listener listener) {
                listener.finally_(TransactionImpl.this);
            }
        });
    }

    @Override
    public void start() {
        this._events.safeDispatch(new Visitor<Transaction.Listener>(){

            @Override
            public void visit(Transaction.Listener listener) throws Exception {
                listener.start(TransactionImpl.this);
            }
        });
    }
}

