/*
 * Decompiled with CFR 0.152.
 */
package net.model3.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class VerticalLayout
implements LayoutManager {
    private int _width;
    private int _gap = 3;

    public VerticalLayout(int n) {
        this._width = n;
    }

    public VerticalLayout() {
    }

    public int getMaximumWidth() {
        return this._width;
    }

    public void setMaximumWidth(int n) {
        this._width = n;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void layoutContainer(Container container) {
        int n = this._gap;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = component.getPreferredSize();
            component.setBounds(0, n, this._width, dimension.height);
            n += dimension.height + this._gap;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        int n = this._gap;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = component.getMinimumSize();
            component.setBounds(0, n, this._width, dimension.height);
            n += dimension.height + this._gap;
        }
        return new Dimension(this._width, n);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        int n = this._gap;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = component.getPreferredSize();
            component.setBounds(0, n, this._width, dimension.height);
            n += dimension.height + this._gap;
        }
        return new Dimension(this._width, n);
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }
}

