/*
 * Decompiled with CFR 0.152.
 */
package net.model3.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import net.model3.lang.ClassX;
import net.model3.lang.TypeManagerFactory;
import net.model3.lang.Visitor;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.swing.AbstractComponentVisitorManager;
import net.model3.swing.ComponentVisitorManager;

public class GuiHelper {
    private static final Logger logger = LoggerHelper.getLogger();
    private static int[][] _buttonMasks = new int[][]{{1, 16}, {2, 8}, {3, 4}, {1, 1024}, {2, 2048}, {3, 4096}};
    private static int _buttonMaskAll = 0;
    static TypeManagerFactory<ComponentVisitorManager<? extends Component>> _componentVisitorManagerFactory;

    public static void doLayoutHack(Component component) {
        GuiHelper.doLayoutHack(component, false);
    }

    public static void doLayoutHack(Component component, boolean bl) {
        if (component != null) {
            component.invalidate();
            component.validate();
            component.repaint();
            if (bl) {
                GuiHelper.doLayoutHack(component.getParent(), true);
            }
        }
    }

    public static Component getEldestAncestor(Component component) {
        if (component.getParent() != null) {
            return GuiHelper.getEldestAncestor(component.getParent());
        }
        return component;
    }

    public static void doWithAntiAliasing(Graphics graphics, Runnable runnable) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        runnable.run();
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object2);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public static void enableDescendants(JComponent jComponent, final boolean bl) {
        GuiHelper.visitDescendants(jComponent, new Visitor<JComponent>(){

            @Override
            public void visit(JComponent jComponent) {
                jComponent.setEnabled(bl);
            }
        });
    }

    public static void visitAncestors(Component component, Visitor<Container> visitor) {
        Container container = component.getParent();
        if (container != null) {
            Visitor.Helper.safeVisit(visitor, container);
            GuiHelper.visitAncestors(container, visitor);
        }
    }

    public static Component getFirstVisibleComponent(Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            return component;
        }
        return null;
    }

    public static void visitComponentAndDescendants(Component component, Visitor<JComponent> visitor) {
        GuiHelper.visitDescendantsImpl(component, visitor, true, true);
    }

    public static void visitDescendants(Component component, Visitor<JComponent> visitor) {
        GuiHelper.visitDescendantsImpl(component, visitor, true, false);
    }

    public static void visitDirectDescendantsOnly(Component component, Visitor<JComponent> visitor) {
        GuiHelper.visitDescendantsImpl(component, visitor, false, false);
    }

    static void visitDescendantsImpl(Component component, Visitor<JComponent> visitor, boolean bl, boolean bl2) {
        DescendingVisitor descendingVisitor = new DescendingVisitor(bl, visitor);
        if (bl2 && component instanceof JComponent) {
            Visitor.Helper.safeVisit(visitor, (JComponent)component);
        }
        ComponentVisitorManager<? extends Component> componentVisitorManager = _componentVisitorManagerFactory.getManager(component);
        componentVisitorManager.visitDirectDescendants(component, descendingVisitor);
    }

    public static void positionWindowFullyOnScreen(Window window, Point point, LocationType locationType) {
        Cloneable cloneable;
        Point point2;
        if (point == null) {
            point2 = window.getLocation();
        } else if (locationType == LocationType.Center) {
            cloneable = window.getSize();
            point2 = new Point();
            point2.x = point.x - cloneable.width / 2;
            point2.y = point.y - cloneable.height / 2;
        } else if (locationType == LocationType.UpperLeft) {
            point2 = point;
        } else {
            throw new RuntimeException("must pass a location type with non-null locations");
        }
        cloneable = new Point();
        ((Point)cloneable).x = window.getWidth() + point2.x;
        ((Point)cloneable).y = window.getHeight() + point2.y;
        Point point3 = new Point(point2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if ((double)((Point)cloneable).x > dimension.getWidth()) {
            point3.x -= (int)((double)((Point)cloneable).x - dimension.getWidth());
        }
        if ((double)((Point)cloneable).y > dimension.getHeight()) {
            point3.y -= (int)((double)((Point)cloneable).y - dimension.getHeight());
        }
        if (point3.x < 0) {
            window.setSize(dimension.width - 30, window.getHeight());
            point3.x = 0;
        }
        if (point3.y < 0) {
            window.setSize(window.getWidth(), dimension.height - 30);
            point3.y = 0;
        }
        window.setLocation(point3);
    }

    public static int getButtonNumber(MouseEvent mouseEvent) {
        return mouseEvent.getButton();
    }

    public static boolean isContextMenuTrigger(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            return true;
        }
        int n = GuiHelper.getButtonNumber(mouseEvent);
        return n == 1 && mouseEvent.isControlDown() || n > 1;
    }

    public static void enableAntiAliasedText() {
        System.setProperty("swing.aatext", "true");
    }

    public static JFrame createFrame(JComponent jComponent) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.add(jComponent);
        jFrame.pack();
        jFrame.setVisible(true);
        return jFrame;
    }

    public static boolean isParent(Component component, Component component2) {
        if (component2 == null) {
            return false;
        }
        if (component == component2) {
            return true;
        }
        return GuiHelper.isParent(component, component2.getParent());
    }

    public static void registerComponentVisitorManager(ComponentVisitorManager<?> componentVisitorManager) {
        _componentVisitorManagerFactory.addManager(componentVisitorManager);
    }

    public static void addTabKeyFocusTraversal(JComponent jComponent) {
        jComponent.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "transferFocus");
        jComponent.getInputMap().put(KeyStroke.getKeyStroke(9, 64), "transferFocusBackward");
        jComponent.getActionMap().put("transferFocus", new AbstractAction(){
            private static final long serialVersionUID = -5644390861803492172L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)actionEvent.getSource()).transferFocus();
            }
        });
        jComponent.getActionMap().put("transferFocusBackward", new AbstractAction(){
            private static final long serialVersionUID = -5644390861803492172L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)actionEvent.getSource()).transferFocusBackward();
            }
        });
    }

    public static JLayeredPane getRootLayeredPane(Component component) {
        Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (window instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)window)).getLayeredPane();
        }
        return null;
    }

    public static <T extends RootPaneContainer> T getRootPaneContainer(Component component) {
        Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (window instanceof RootPaneContainer) {
            return (T)((RootPaneContainer)((Object)window));
        }
        return null;
    }

    public static <T extends Window> T getWindowAncestor(Component component) {
        if (component instanceof Window) {
            return (T)((Window)component);
        }
        return (T)SwingUtilities.getWindowAncestor(component);
    }

    public static int getScrollBarWidth() {
        return 20;
    }

    public static ImageIcon loadIcon(String string) {
        URL uRL = ClassX.getResource(string);
        if (uRL == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            throw new RuntimeException("unable to find image " + string + " using classloader " + classLoader);
        }
        try {
            ImageIcon imageIcon = new ImageIcon(uRL);
            return imageIcon;
        }
        catch (Exception exception) {
            throw new RuntimeException("unable to find image " + string + " in classpath", exception);
        }
    }

    public static void makeSameLocationOnScreen(Component component, Component component2) {
        try {
            Point point = component.getLocationOnScreen();
            Point point2 = component2.getLocationOnScreen();
            int n = point.x - point2.x;
            int n2 = point.y - point2.y;
            component2.setLocation(component2.getX() + n, component2.getY() + n2);
        }
        catch (Exception exception) {
            logger.warn((Object)exception.getMessage());
        }
    }

    public static void center(Component component, Dialog dialog) {
        int n = dialog.getWidth();
        int n2 = dialog.getHeight();
        int n3 = component.getLocationOnScreen().x + (component.getWidth() - dialog.getWidth()) / 2;
        int n4 = component.getLocationOnScreen().y + (component.getHeight() - dialog.getHeight()) / 2;
        dialog.setLocation(n3, n4);
    }

    static {
        for (int[] nArray : _buttonMasks) {
            _buttonMaskAll |= nArray[1];
        }
        _componentVisitorManagerFactory = TypeManagerFactory.create();
        _componentVisitorManagerFactory.addManager((ComponentVisitorManager<? extends Component>)new AbstractComponentVisitorManager<Component>(){

            @Override
            public void visitDirectDescendants(Component component, Visitor<Component> visitor) {
                if (component instanceof Container) {
                    Container container = (Container)component;
                    int n = container.getComponentCount();
                    for (int i = 0; i < n; ++i) {
                        Visitor.Helper.safeVisit(visitor, container.getComponent(i));
                    }
                }
            }
        });
        _componentVisitorManagerFactory.addManager((ComponentVisitorManager<? extends Component>)new AbstractComponentVisitorManager<JFrame>(){

            @Override
            public void visitDirectDescendants(JFrame jFrame, Visitor<Component> visitor) {
                Visitor.Helper.safeVisit(visitor, jFrame.getLayeredPane());
                if (jFrame.getGlassPane() != null) {
                    Visitor.Helper.safeVisit(visitor, jFrame.getGlassPane());
                }
            }
        });
    }

    static class DescendingVisitor
    implements Visitor<Component> {
        boolean _descendDeeply;
        Visitor<JComponent> _descendantVisitor;

        private DescendingVisitor(boolean bl, Visitor<JComponent> visitor) {
            this._descendDeeply = bl;
            this._descendantVisitor = visitor;
        }

        @Override
        public void visit(Component component) {
            if (component instanceof JComponent) {
                Visitor.Helper.safeVisit(this._descendantVisitor, (JComponent)component);
            }
            if (this._descendDeeply) {
                ComponentVisitorManager<? extends Component> componentVisitorManager = _componentVisitorManagerFactory.getManager(component);
                componentVisitorManager.visitDirectDescendants(component, this);
            }
        }
    }

    public static enum LocationType {
        UpperLeft,
        Center;

    }
}

