/*
 * Decompiled with CFR 0.152.
 */
package net.model3.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class FixedGridLayout
implements LayoutManager {
    private final Logger logger = LoggerHelper.getLogger();
    private int _width;

    public int getMaximumWidth() {
        return this._width;
    }

    public void setMaximumWidth(int n) {
        this._width = n;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void layoutContainer(Container container) {
        Dimension dimension = this.getCellSize(container);
        Dimension dimension2 = new Dimension();
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        int n = this._width / dimension.width;
        if (n == 0) {
            n = 1;
        }
        int n2 = container.getComponentCount() / n + 1;
        int n3 = (container.getWidth() - n * dimension.width) / (n + 1);
        int n4 = container.getComponentCount();
        for (int i = 0; i < n4; ++i) {
            int n5 = i % n;
            int n6 = i / n;
            int n7 = n5 * (dimension.width + n3) + n3;
            int n8 = n6 * dimension.height;
            Component component = container.getComponent(i);
            component.setLocation(n7, n8);
            component.setSize(component.getPreferredSize());
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = this.getCellSize(container);
        Dimension dimension2 = new Dimension();
        if (dimension.width == 0 || dimension.height == 0) {
            return dimension2;
        }
        int n = this._width / dimension.width;
        if (n == 0) {
            n = 1;
        }
        int n2 = (container.getComponentCount() - 1) / n + 1;
        dimension2.width = n * dimension.width;
        dimension2.height = n2 * dimension.height;
        return dimension2;
    }

    Dimension getCellSize(Container container) {
        Dimension dimension = new Dimension();
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension2 = component.getPreferredSize();
            if (dimension2.width > dimension.width) {
                dimension.width = dimension2.width;
            }
            if (dimension2.height <= dimension.height) continue;
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }
}

