/*
 * Decompiled with CFR 0.152.
 */
package net.model3.swing;

import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Set;
import net.model3.collections.ListX;
import net.model3.collections.SetX;
import net.model3.guice.ImmutableValue;
import net.model3.guice.ReadableValue;
import net.model3.lang.Visitor;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class EventManager<T> {
    private static final Logger logger = LoggerHelper.getLogger();
    private List<ReadableValue<T>> _listeners = ListX.create();
    private boolean _defaultToSoftReferences;

    public EventManager() {
    }

    public EventManager(boolean bl) {
        this._defaultToSoftReferences = bl;
    }

    public void addListener(T t) {
        this.addListener(t, this._defaultToSoftReferences);
    }

    public void addListener(T t, boolean bl) {
        this._listeners.add(this.createRef(t, bl));
    }

    public void removeListener(T t) {
        this._listeners.remove(t);
    }

    public void setDefaultToSoftReferences(boolean bl) {
        this._defaultToSoftReferences = bl;
    }

    public void dispatch(Visitor<T> visitor) throws Exception {
        Set<ReadableValue<T>> set = SetX.create();
        for (ReadableValue<T> readableValue : ListX.create(this._listeners)) {
            T t = readableValue.get();
            if (t == null) {
                set.add(readableValue);
                continue;
            }
            visitor.visit(t);
        }
        for (ReadableValue<T> readableValue : set) {
            try {
                this._listeners.remove(readableValue);
            }
            catch (Exception exception) {
                logger.warn((Object)"unable to remove gc'ed listener", (Object)exception);
            }
        }
    }

    public void safeDispatch(Visitor<T> visitor) {
        Set<ReadableValue<T>> set = SetX.create();
        for (ReadableValue<T> readableValue : ListX.create(this._listeners)) {
            T t = readableValue.get();
            if (t == null) {
                set.add(readableValue);
                continue;
            }
            try {
                visitor.visit(t);
            }
            catch (Exception exception) {
                logger.debug((Object)"catching and swallowing error in listener {}", (Object)t, (Object)exception);
            }
        }
        for (ReadableValue<T> readableValue : set) {
            try {
                this._listeners.remove(readableValue);
            }
            catch (Exception exception) {
                logger.warn((Object)"unable to remove gc'ed listener", (Object)exception);
            }
        }
    }

    public static <T> EventManager<T> create() {
        return new EventManager<T>();
    }

    public static <T> EventManager<T> create(boolean bl) {
        return new EventManager<T>(bl);
    }

    ReadableValue<T> createRef(T t, boolean bl) {
        if (bl) {
            return new SoftRefMutableValue(t);
        }
        return new ImmutableValue<T>(t);
    }

    class SoftRefMutableValue
    implements ReadableValue<T> {
        private static final long serialVersionUID = -8217261703384925379L;
        SoftReference<T> _reference;

        public SoftRefMutableValue(T t) {
            this._reference = new SoftReference(t);
        }

        @Override
        public T get() {
            return this._reference.get();
        }
    }
}

