/*
 * Decompiled with CFR 0.152.
 */
package net.model3.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.AbstractBorder;

public class CurvedBorder
extends AbstractBorder {
    private static final long serialVersionUID = -7245967162051323641L;
    protected int thickness;
    protected Color lineColor;
    protected int arcSize;

    public CurvedBorder(Color color) {
        this(color, 1, 3);
    }

    public CurvedBorder(Color color, int n) {
        this(color, n, 3);
    }

    public CurvedBorder(Color color, int n, int n2) {
        this.lineColor = color;
        this.thickness = n;
        this.arcSize = n2;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        Object object = ((Graphics2D)graphics).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(this.lineColor);
        for (int i = 0; i < this.thickness; ++i) {
            graphics.drawRoundRect(n + i, n2 + i, n3 - i - i - 1, n4 - i - i - 1, this.arcSize, this.arcSize);
        }
        graphics.setColor(color);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.right = insets.bottom = this.thickness;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getThickness() {
        return this.thickness;
    }
}

