/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet.upload.parser;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MacBinaryDecoderOutputStream
extends FilterOutputStream {
    private int bytesFiltered = 0;
    private int dataForkLength = 0;

    public MacBinaryDecoderOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void write(int n) throws IOException {
        if (this.bytesFiltered <= 86 && this.bytesFiltered >= 83) {
            int n2 = (86 - this.bytesFiltered) * 8;
            this.dataForkLength |= (n & 0xFF) << n2;
        } else if (this.bytesFiltered < 128 + this.dataForkLength && this.bytesFiltered >= 128) {
            this.out.write(n);
        }
        ++this.bytesFiltered;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.bytesFiltered >= 128 + this.dataForkLength) {
            this.bytesFiltered += n2;
        } else if (this.bytesFiltered >= 128 && this.bytesFiltered + n2 <= 128 + this.dataForkLength) {
            this.out.write(byArray, n, n2);
            this.bytesFiltered += n2;
        } else {
            for (int i = 0; i < n2; ++i) {
                this.write(byArray[n + i]);
            }
        }
    }
}

