/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet.upload.parser;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;
import net.model3.servlet.upload.parser.MacBinaryDecoderOutputStream;
import net.model3.servlet.upload.parser.Part;
import net.model3.servlet.upload.parser.PartInputStream;

public class FilePart
extends Part {
    private String fileName;
    private String filePath;
    private String contentType;
    private PartInputStream partInput;

    FilePart(String string, ServletInputStream servletInputStream, String string2, String string3, String string4, String string5) throws IOException {
        super(string);
        this.fileName = string4;
        this.filePath = string5;
        this.contentType = string3;
        this.partInput = new PartInputStream(servletInputStream, string2);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return this.partInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeTo(File file) throws IOException {
        long l = 0L;
        try (OutputStream outputStream = null;){
            if (this.fileName != null) {
                File file2 = file.isDirectory() ? new File(file, this.fileName) : file;
                outputStream = new BufferedOutputStream(new FileOutputStream(file2));
                l = this.write(outputStream);
            }
        }
        return l;
    }

    public long writeTo(OutputStream outputStream) throws IOException {
        long l = 0L;
        if (this.fileName != null) {
            l = this.write(outputStream);
        }
        return l;
    }

    long write(OutputStream outputStream) throws IOException {
        int n;
        if (this.contentType.equals("application/x-macbinary")) {
            outputStream = new MacBinaryDecoderOutputStream(outputStream);
        }
        long l = 0L;
        byte[] byArray = new byte[8192];
        while ((n = this.partInput.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    @Override
    public boolean isFile() {
        return true;
    }
}

