/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet.upload;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.servlet.upload.UploadedFile;

final class MultipartHttpServletRequest
extends HttpServletRequestWrapper {
    private static final Logger logger = LoggerHelper.getLogger();
    private List<UploadedFile> _uploadedFiles;
    private Map<String, String[]> _finalParmsMap;

    MultipartHttpServletRequest(HttpServletRequest httpServletRequest, Map<String, String[]> map, List<UploadedFile> list) {
        super(httpServletRequest);
        this._finalParmsMap = map;
        this._uploadedFiles = list;
    }

    public String getParameter(String string) {
        String[] stringArray = this._finalParmsMap.get(string);
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public Map getParameterMap() {
        return this._finalParmsMap;
    }

    public Enumeration getParameterNames() {
        final Iterator<String> iterator = this._finalParmsMap.keySet().iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
    }

    public String[] getParameterValues(String string) {
        return this._finalParmsMap.get(string);
    }

    public void cleanup() {
        for (UploadedFile uploadedFile : this._uploadedFiles) {
            if (!uploadedFile.getTempFile().exists()) continue;
            try {
                uploadedFile.getTempFile().delete();
            }
            catch (Exception exception) {
                logger.debug((Object)"unable to cleanup temp file {}", (Object)uploadedFile.getTempFile(), (Object)exception);
            }
        }
    }
}

