/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet.upload;

import com.google.inject.Singleton;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.model3.servlet.BeanSetterFilter;
import net.model3.servlet.upload.CommonsFileUploadDriver;
import net.model3.servlet.upload.FileUploadDriver;
import net.model3.servlet.upload.MultipartHttpServletRequest;

@Singleton
public class FileUploadFilter
extends BeanSetterFilter {
    private static final Logger logger = LoggerHelper.getLogger();
    private Directory _temp;
    private String _prefix = "upload";
    private String _suffix = "temp";
    private boolean _cleanup = true;
    private FileUploadDriver _fileUploadDriver = new CommonsFileUploadDriver();

    public String getPrefix() {
        return this._prefix;
    }

    public void setPrefix(String string) {
        this._prefix = string;
    }

    public FileUploadDriver getFileUploadDriver() {
        return this._fileUploadDriver;
    }

    public void setFileUploadDriver(FileUploadDriver fileUploadDriver) {
        this._fileUploadDriver = fileUploadDriver;
    }

    public Directory getTemp() {
        return this._temp;
    }

    public String getSuffix() {
        return this._suffix;
    }

    public void setSuffix(String string) {
        this._suffix = string;
    }

    public boolean isCleanup() {
        return this._cleanup;
    }

    public void setCleanup(boolean bl) {
        this._cleanup = bl;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this._temp = new Directory(filterConfig.getServletContext().getRealPath("WEB-INF/tmp-file-upload/"));
        this._temp.makeDirectories();
        try {
            this._temp.deleteTree(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._fileUploadDriver.setFileUploadFilter(this);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        try {
            servletRequest = this._fileUploadDriver.processRequest(servletRequest);
            filterChain.doFilter(servletRequest, servletResponse);
            if (this.isCleanup() && servletRequest instanceof MultipartHttpServletRequest) {
                try {
                    ((MultipartHttpServletRequest)servletRequest).cleanup();
                }
                catch (Exception exception) {
                    logger.debug((Object)"cleanup failed", (Object)exception);
                }
            }
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    @Override
    public void destroy() {
    }
}

