/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet.compress;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.servlet.compress.CompressionResponseStream;

public class CompressionServletResponseWrapper
extends HttpServletResponseWrapper {
    private final Logger logger = LoggerHelper.getLogger();
    protected HttpServletResponse _origResponse = null;
    protected CompressionResponseStream _stream = null;
    protected PrintWriter _writer = null;
    protected int _minimumSizetoCompress = 0;
    protected String _contentType = null;

    public CompressionServletResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
        this._origResponse = httpServletResponse;
        this.logger.trace((Object)"new CompressionServletResponseWrapper()");
    }

    public void setContentType(String string) {
        this.logger.trace((Object)"setContentType to {}", (Object)string);
        this._contentType = string;
        this._origResponse.setContentType(string);
    }

    public void setMinimumSizeToCompress(int n) {
        this.logger.trace((Object)"setMinimumSizeToCompress() to {}", (Object)n);
        this._minimumSizetoCompress = n;
    }

    public CompressionResponseStream createOutputStream() throws IOException {
        this.logger.trace((Object)"createOutputStream called");
        CompressionResponseStream compressionResponseStream = new CompressionResponseStream(this._origResponse);
        compressionResponseStream.setBuffer(this._minimumSizetoCompress);
        return compressionResponseStream;
    }

    public void finishResponse(String string) {
        try {
            if (this._writer != null) {
                this._writer.close();
            } else if (this._stream != null) {
                this._stream.close();
            }
            if (this._stream != null) {
                this.logger.debug((Object)"{}   original size = {}  compressed size = {}", (Object)string, (Object)this._stream.getUnCompressedByteCount(), (Object)this._stream.getCompressedByteCount());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flushBuffer() throws IOException {
        if (this._stream != null) {
            this.logger.trace((Object)"flushBuffer()");
            this._stream.flush();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._writer != null) {
            throw new IllegalStateException("getWriter() has already been called for this response");
        }
        if (this._stream == null) {
            this._stream = this.createOutputStream();
        }
        this.logger.trace((Object)"stream is set to {} in getOutputStream", (Object)this._stream);
        return this._stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._writer != null) {
            return this._writer;
        }
        if (this._stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called for this response");
        }
        this._stream = this.createOutputStream();
        this.logger.trace((Object)"stream is set to {} in getWriter", (Object)this._stream);
        String string = this._origResponse.getCharacterEncoding();
        this.logger.trace((Object)"character encoding is {}", (Object)string);
        this._writer = string != null ? new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this._stream), string)) : new PrintWriter((OutputStream)((Object)this._stream));
        return this._writer;
    }

    public void setContentLength(int n) {
    }
}

