/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet.compress;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.model3.io.ByteCountingStream;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class CompressionResponseStream
extends ServletOutputStream {
    private final Logger logger = LoggerHelper.getLogger();
    private int _compressionThreshold = 0;
    private byte[] _buffer = null;
    private int _bufferCount = 0;
    private ByteCountingStream _gzipstream = null;
    private boolean _closed = false;
    private int _length = -1;
    private HttpServletResponse _response = null;
    private ByteCountingStream _output = null;
    private Integer _compressByteCount;
    private Integer _uncompressedByteCount;

    public CompressionResponseStream(HttpServletResponse httpServletResponse) throws IOException {
        this._response = httpServletResponse;
        this._output = new ByteCountingStream((OutputStream)httpServletResponse.getOutputStream());
    }

    protected void setBuffer(int n) {
        this._compressionThreshold = n;
        this._buffer = new byte[this._compressionThreshold];
        this.logger.trace((Object)"buffer is set to {}", (Object)this._compressionThreshold);
    }

    public void close() throws IOException {
        this.logger.trace((Object)"close()");
        if (this._closed) {
            throw new IOException("This output stream has already been closed");
        }
        if (this._gzipstream != null) {
            this.flushToGZip();
            this._gzipstream.close();
            this._uncompressedByteCount = this._gzipstream.getByteCount();
            this._gzipstream = null;
        } else if (this._bufferCount > 0) {
            this._output.write(this._buffer, 0, this._bufferCount);
            this._bufferCount = 0;
        }
        this._output.close();
        this._compressByteCount = this._output.getByteCount();
        this._closed = true;
    }

    public void flush() throws IOException {
        if (this._closed) {
            throw new IOException("Cannot flush a closed output stream");
        }
        if (this._gzipstream != null) {
            this._gzipstream.flush();
        }
    }

    public void flushToGZip() throws IOException {
        if (this._bufferCount > 0) {
            this.writeToGZip(this._buffer, 0, this._bufferCount);
            this._bufferCount = 0;
        }
    }

    public void write(int n) throws IOException {
        if (this._closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (this._bufferCount >= this._buffer.length) {
            this.flushToGZip();
        }
        this._buffer[this._bufferCount++] = (byte)n;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this._closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (n2 == 0) {
            return;
        }
        if (n2 <= this._buffer.length - this._bufferCount) {
            System.arraycopy(byArray, n, this._buffer, this._bufferCount, n2);
            this._bufferCount += n2;
            return;
        }
        this.flushToGZip();
        if (n2 <= this._buffer.length - this._bufferCount) {
            System.arraycopy(byArray, n, this._buffer, this._bufferCount, n2);
            this._bufferCount += n2;
            return;
        }
        this.writeToGZip(byArray, n, n2);
    }

    public void writeToGZip(byte[] byArray, int n, int n2) throws IOException {
        if (this._gzipstream == null) {
            if (this._response.isCommitted()) {
                this._gzipstream = this._output;
            } else {
                this._response.addHeader("Content-Encoding", "gzip");
                this._gzipstream = new ByteCountingStream(new GZIPOutputStream(this._output));
            }
        }
        this._gzipstream.write(byArray, n, n2);
    }

    public boolean closed() {
        return this._closed;
    }

    public Integer getUnCompressedByteCount() {
        return this._uncompressedByteCount;
    }

    public Integer getCompressedByteCount() {
        return this._compressByteCount;
    }
}

