/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet.compress;

import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.servlet.compress.CompressionServletResponseWrapper;

@Singleton
public class CompressionFilter
implements Filter {
    private static final Logger logger = LoggerHelper.getLogger();
    private FilterConfig _config = null;
    protected int _minimumSizeToCompress = 1024;

    public void init(FilterConfig filterConfig) {
        String string;
        this._config = filterConfig;
        if (filterConfig != null && (string = filterConfig.getInitParameter("minimumSizeToCompress")) != null) {
            this._minimumSizeToCompress = Integer.parseInt(string);
        }
        logger.trace((Object)"_minimumSizeToCompress = {}", (Object)this._minimumSizeToCompress);
    }

    public void destroy() {
        this._config = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse object, FilterChain filterChain) throws IOException, ServletException {
        Object object2;
        String string = "";
        boolean bl = false;
        if (servletRequest instanceof HttpServletRequest) {
            object2 = (HttpServletRequest)servletRequest;
            string = object2.getRequestURI();
            logger.trace((Object)("requestURI = " + object2.getRequestURI()));
            String string2 = object2.getParameter("gzip");
            if ("false".equals(string2)) {
                logger.trace((Object)"got parameter gzip=false --> don't compress, just chain filter");
                filterChain.doFilter((ServletRequest)object2, object);
                return;
            }
            Enumeration enumeration = object2.getHeaders("Accept-Encoding");
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (string3.indexOf("gzip") == -1) continue;
                bl = true;
                break;
            }
            if (bl) {
                logger.trace((Object)"supports compression");
            } else {
                logger.trace((Object)"no support for compresion");
            }
        }
        object2 = null;
        if (bl && object instanceof HttpServletResponse) {
            object2 = new CompressionServletResponseWrapper((HttpServletResponse)object);
            ((CompressionServletResponseWrapper)((Object)object2)).setMinimumSizeToCompress(this._minimumSizeToCompress);
            object = object2;
            logger.trace((Object)"doFilter gets called with compression");
        } else {
            logger.trace((Object)"doFilter gets called wo compression");
        }
        try {
            filterChain.doFilter(servletRequest, object);
        }
        finally {
            if (object2 != null) {
                ((CompressionServletResponseWrapper)((Object)object2)).finishResponse(string);
            }
        }
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.init(filterConfig);
    }

    public FilterConfig getFilterConfig() {
        return this._config;
    }
}

