/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet;

import java.io.Serializable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import net.model3.lang.SystemX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.servlet.WebRequest;

public class WebSession
implements Serializable,
HttpSessionBindingListener {
    private static final long serialVersionUID = 7719950568858622122L;
    static final String SESSION_KEY = WebSession.class.getName();
    private static final Logger logger = LoggerHelper.getLogger();
    private transient HttpSession session_;

    protected static WebSession getImpl() {
        return ((WebRequest)WebRequest.getImpl()).getWebSessionImpl();
    }

    protected static WebSession getImpl(boolean bl) {
        return ((WebRequest)WebRequest.getImpl()).getWebSessionImpl(bl);
    }

    public String getLoggingContext() {
        return "Session=" + SystemX.identityHexHashCode(this);
    }

    protected void started() {
    }

    protected HttpSession getHttpSession() {
        if (this.session_ == null) {
            this.session_ = ((WebRequest)WebRequest.getImpl()).getHttpServletRequest().getSession(true);
        }
        return this.session_;
    }

    protected void ended() {
        logger.debug((Object)("ending web session " + this));
        if (WebRequest.getImpl() != null) {
            ((WebRequest)WebRequest.getImpl()).resetWebSession();
        }
        this.session_ = null;
    }

    public void invalidate() {
        logger.debug((Object)(this + " invalidated"));
        this.session_.invalidate();
    }

    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (this.session_ != null && this.session_ != httpSessionBindingEvent.getSession()) {
            logger.error((Object)("already bound to session " + this.session_ + " cannot bind to session " + httpSessionBindingEvent.getSession()));
        } else {
            this.session_ = httpSessionBindingEvent.getSession();
            logger.debug((Object)(this + " bound to session " + this.session_ + "  key=" + httpSessionBindingEvent.getName()));
        }
    }

    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
        logger.debug((Object)(this + " unbound from session " + this.session_));
    }

    public boolean isNew() {
        return this.getHttpSession().isNew();
    }
}

