/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet;

import com.google.inject.Singleton;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.model3.lang.ExceptionPropagator;
import net.model3.servlet.BeanSetterFilter;
import net.model3.servlet.WebApp;
import net.model3.servlet.WebRequest;

@Singleton
public class WebRequestFilter
extends BeanSetterFilter {
    private WebApp webApp_;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        this.getWebApp();
        if (this.webApp_ != null) {
            this.webApp_.requestStarted(servletRequest, servletResponse, true);
        }
        Object t = WebRequest.getImpl();
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        catch (Exception exception) {
            if (((WebRequest)t).getError() == null) {
                ((WebRequest)t).setError(exception);
            }
            throw ExceptionPropagator.wrapServletException(exception);
        }
        finally {
            this.webApp_.requestEnded();
        }
    }

    WebApp getWebApp() {
        if (this.webApp_ == null) {
            this.webApp_ = WebApp.getImpl();
        }
        return this.webApp_;
    }
}

