/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.net.UrlX;
import net.model3.servlet.ActionFactory;
import net.model3.servlet.BrowserProperties;
import net.model3.servlet.WebApp;
import net.model3.servlet.WebSession;
import org.apache.log4j.NDC;

public class WebRequest {
    private static final Logger logger = LoggerHelper.getLogger();
    private ServletRequest servletRequest_;
    private ServletResponse servletResponse_;
    private boolean hasLoggingContext_ = false;
    private WebApp webApp_;
    private WebSession webSession_;
    private ActionFactory actionFactory_;
    private BrowserProperties browserProperties_;
    private Exception error_;
    private WebRequest previousRequestInStack_;

    public WebApp getWebApp() {
        return this.webApp_;
    }

    void setWebApp(WebApp webApp) {
        this.webApp_ = webApp;
    }

    protected ServletRequest getServletRequest() {
        return this.servletRequest_;
    }

    protected ServletResponse getServletResponse() {
        return this.servletResponse_;
    }

    public void init(ServletRequest servletRequest, ServletResponse servletResponse) {
        this.servletRequest_ = servletRequest;
        this.servletResponse_ = servletResponse;
    }

    public HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.getServletRequest();
    }

    public HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)this.getServletResponse();
    }

    protected void started() {
        String string;
        NDC.clear();
        String string2 = "";
        WebSession webSession = WebSession.getImpl(false);
        if (webSession != null) {
            string2 = webSession.getLoggingContext();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if ((string = this.getLoggingContext()) != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(":");
            }
            stringBuffer.append(string);
        }
        if (stringBuffer.length() > 0) {
            this.hasLoggingContext_ = true;
            NDC.push((String)stringBuffer.toString());
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"webapp request started");
        }
    }

    public String getLoggingContext() {
        return this.getHttpServletRequest().getRequestURI();
    }

    public void ended() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"webapp request ended");
        }
        if (this.hasLoggingContext_) {
            NDC.pop();
        }
    }

    public static <T extends WebRequest> T getImpl() {
        WebRequest webRequest = WebApp.getImpl().getWebRequest();
        return (T)webRequest;
    }

    WebSession getWebSessionImpl() {
        return this.getWebSessionImpl(true);
    }

    WebSession getWebSessionImpl(boolean bl) {
        HttpSession httpSession;
        if (this.webSession_ == null && (httpSession = this.getHttpServletRequest().getSession(bl)) != null) {
            this.webSession_ = (WebSession)httpSession.getAttribute(WebSession.SESSION_KEY);
        }
        return this.webSession_;
    }

    public void setWebSession(WebSession webSession) {
        this.webSession_ = webSession;
    }

    void resetWebSession() {
        this.webSession_ = null;
    }

    public boolean hasLoggingContext() {
        return this.hasLoggingContext_;
    }

    WebRequest getPreviousRequestInStack() {
        return this.previousRequestInStack_;
    }

    void setPreviousRequestInStack(WebRequest webRequest) {
        this.previousRequestInStack_ = webRequest;
    }

    public String getUserAgent() {
        return this.getHttpServletRequest().getHeader("User-Agent");
    }

    public String getFullURL() {
        String string = StringX.isBlank(this.getHttpServletRequest().getQueryString()) ? "" : "?" + this.getHttpServletRequest().getQueryString();
        String string2 = this.getHttpServletRequest().getRequestURL() + string;
        return string2;
    }

    public String getReferringUrl() {
        return this.getHttpServletRequest().getHeader("Referer");
    }

    public BrowserProperties getBrowserProperties() {
        if (this.browserProperties_ == null) {
            this.browserProperties_ = new BrowserProperties(this.getUserAgent());
        }
        return this.browserProperties_;
    }

    public void setError(Exception exception) {
        this.error_ = exception;
    }

    public Exception getError() {
        return this.error_;
    }

    public UrlX getRootUrl() {
        return new UrlX(this.getHttpServletRequest().getRequestURL().toString()).getRootUrl();
    }

    public void setHeadersForNoCaching() {
        this.getHttpServletResponse().setHeader("Cache-Control", "no-cache, must-revalidate, max_age=0");
        this.getHttpServletResponse().setHeader("Pragma", "no-cache");
        this.getHttpServletResponse().setHeader("Expires", "0");
    }

    public void redirectToUrl(String string) {
        try {
            logger.trace((Object)("redirecting to url=" + string));
            this.getHttpServletResponse().sendRedirect(string);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public Object getRequestAsHtmlString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<br>context-path: " + this.getHttpServletRequest().getContextPath());
        stringBuffer.append("<br>method: " + this.getHttpServletRequest().getMethod());
        stringBuffer.append("<br>path-info: " + this.getHttpServletRequest().getPathInfo());
        stringBuffer.append("<br>path-translated: " + this.getHttpServletRequest().getPathTranslated());
        stringBuffer.append("<br>protocol: " + this.getHttpServletRequest().getProtocol());
        stringBuffer.append("<br>query-string: " + this.getHttpServletRequest().getQueryString());
        stringBuffer.append("<br>remote-addr: " + this.getHttpServletRequest().getRemoteAddr());
        stringBuffer.append("<br>remote-host: " + this.getHttpServletRequest().getRemoteHost());
        stringBuffer.append("<br>remote-user: " + this.getHttpServletRequest().getRemoteUser());
        stringBuffer.append("<br>session-id: " + this.getHttpServletRequest().getRequestedSessionId());
        stringBuffer.append("<br>request-uri: " + this.getHttpServletRequest().getRequestURI());
        stringBuffer.append("<br>request-url: " + this.getHttpServletRequest().getRequestURL());
        stringBuffer.append("<br>scheme: " + this.getHttpServletRequest().getScheme());
        stringBuffer.append("<br>server-name: " + this.getHttpServletRequest().getServerName());
        stringBuffer.append("<br>server-port: " + this.getHttpServletRequest().getServerPort());
        stringBuffer.append("<br>servlet-path: " + this.getHttpServletRequest().getServletPath());
        stringBuffer.append("<br>session-from-cookie: " + this.getHttpServletRequest().isRequestedSessionIdFromCookie());
        stringBuffer.append("<br>session-from-url: " + this.getHttpServletRequest().isRequestedSessionIdFromURL());
        stringBuffer.append("<br>secure: " + this.getHttpServletRequest().isSecure());
        return stringBuffer.toString();
    }

    public Cookie getCookie(String string) {
        Cookie[] cookieArray = this.getHttpServletRequest().getCookies();
        if (cookieArray != null) {
            for (Cookie cookie : cookieArray) {
                if (!cookie.getName().equals(string)) continue;
                return cookie;
            }
        }
        return null;
    }

    public void setCookie(String string, String string2) {
        Cookie cookie = this.getCookie(string);
        if (cookie == null) {
            cookie = new Cookie(string, string2);
            cookie.setPath("/");
        }
        this.getHttpServletResponse().addCookie(cookie);
        cookie.setValue(string2);
    }

    public String getCookieValue(String string) {
        Cookie cookie = this.getCookie(string);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    public String getContextPath() {
        return this.getHttpServletRequest().getContextPath();
    }
}

