/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet;

import com.google.inject.Injector;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ClassX;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.LoggerHelper;
import net.model3.servlet.WebApp;

public class WebAppListener
implements ServletContextListener,
HttpSessionListener {
    private static WebApp webApp_;

    public static WebApp getWebApp() {
        return webApp_;
    }

    public static void setWebApp(WebApp webApp) {
        webApp_ = webApp;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        try {
            String string = servletContext.getInitParameter("webappImplClass");
            if (string == null) {
                string = WebApp.class.getName();
            }
            webApp_ = (WebApp)this.getInjector().getInstance(ClassX.load(string));
            webApp_.webappStarted(servletContext, this);
        }
        catch (Throwable throwable) {
            servletContext.log("error starting " + this.getClass().getName(), throwable);
            LoggerHelper.getLogger().error((Object)"", (Object)throwable);
            throw ExceptionPropagator.wrap(throwable);
        }
    }

    public Injector getInjector() {
        return DependencyInjector.get();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (webApp_ != null) {
            webApp_.webappEnded();
        }
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        webApp_.sessionStarted(httpSessionEvent.getSession());
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        webApp_.sessionEnded(httpSessionEvent.getSession());
    }
}

