/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import net.model3.guice.LifeCycleManager;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.servlet.WebAppListener;
import net.model3.servlet.WebRequest;
import net.model3.servlet.WebSession;

@Singleton
public class WebApp {
    private static final Logger logger = LoggerHelper.getLogger();
    private ServletContext servletContext_;
    private final ThreadLocal<Stack<WebRequest>> threadLocalRequests_ = new ThreadLocal<Stack<WebRequest>>(){

        @Override
        protected Stack<WebRequest> initialValue() {
            return new Stack<WebRequest>();
        }
    };
    WebAppListener listener_;
    Map<String, Object> attributes_ = Collections.synchronizedMap(new HashMap());
    @Inject
    LifeCycleManager _lifeCycleHolder;

    protected WebApp() {
    }

    WebAppListener getListener() {
        return this.listener_;
    }

    public ServletContext getServletContext() {
        return this.servletContext_;
    }

    protected void webappStarted(ServletContext servletContext, WebAppListener webAppListener) {
        this.servletContext_ = servletContext;
        this.listener_ = webAppListener;
    }

    protected void webappEnded() {
        this._lifeCycleHolder.destroy.fire();
    }

    void sessionStarted(HttpSession httpSession) {
        String string = "";
        if (WebRequest.getImpl() != null) {
            string = ((WebRequest)WebRequest.getImpl()).getHttpServletRequest().getRemoteAddr();
        }
        logger.debug((Object)("session created " + httpSession + "  remote addr=" + string));
        WebSession webSession = this.createWebSession();
        logger.debug((Object)("webSession " + webSession + "  bound to session " + httpSession + "  attribute=" + WebSession.SESSION_KEY));
        httpSession.setAttribute(WebSession.SESSION_KEY, (Object)webSession);
        webSession.started();
    }

    void sessionEnded(HttpSession httpSession) {
        WebSession webSession = (WebSession)httpSession.getAttribute(WebSession.SESSION_KEY);
        if (webSession != null) {
            webSession.ended();
        }
    }

    protected WebSession createWebSession() {
        try {
            WebSession webSession = this.getWebSessionImplClass().newInstance();
            return webSession;
        }
        catch (Exception exception) {
            logger.error((Object)"", (Object)exception);
            throw ExceptionPropagator.wrap(exception);
        }
    }

    protected Class<? extends WebSession> getWebSessionImplClass() {
        return WebSession.class;
    }

    public void requestStarted(ServletRequest servletRequest, ServletResponse servletResponse, boolean bl) {
        if (bl) {
            this.threadLocalRequests_.get().clear();
        }
        WebRequest webRequest = this.createRequest(servletRequest, servletResponse);
        this.threadLocalRequests_.get().push(webRequest);
        webRequest.setWebApp(this);
        webRequest.started();
    }

    void requestEnded() {
        WebRequest webRequest = this.getWebRequest();
        webRequest.ended();
        this.threadLocalRequests_.get().pop();
    }

    protected WebRequest createRequest(ServletRequest servletRequest, ServletResponse servletResponse) {
        try {
            WebRequest webRequest = this.getWebRequestImplClass().newInstance();
            webRequest.init(servletRequest, servletResponse);
            return webRequest;
        }
        catch (Exception exception) {
            logger.error((Object)"", (Object)exception);
            throw ExceptionPropagator.wrap(exception);
        }
    }

    WebRequest getWebRequest() {
        Stack<WebRequest> stack;
        if (this.threadLocalRequests_.get() != null && (stack = this.getWebRequestStack()).size() > 0) {
            return stack.peek();
        }
        return null;
    }

    protected Class<? extends WebRequest> getWebRequestImplClass() {
        return WebRequest.class;
    }

    public static WebApp getImpl() {
        return WebAppListener.getWebApp();
    }

    public Object getAttribute(String string) {
        return this.attributes_.get(string);
    }

    public Object setAttribute(String string, Object object) {
        return this.attributes_.put(string, object);
    }

    public Object removeAttribute(String string) {
        return this.attributes_.remove(string);
    }

    private Stack<WebRequest> getWebRequestStack() {
        return this.threadLocalRequests_.get();
    }
}

