/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.servlet.BeanSetterFilter;
import net.model3.util.Tokenizer;

public class HttpsProxyFilter
extends BeanSetterFilter {
    private static final Logger logger = LoggerHelper.getLogger();
    public static final String CONTEXT_ATTRIBUTE_PORT_MAPPINGS = HttpsProxyFilter.class.getName() + ".portMappings";
    private Map<Integer, PortMapping> portMappings_;
    private boolean configured_ = false;

    public void doFilter(ServletRequest object, ServletResponse object2, FilterChain filterChain) throws ServletException, IOException {
        Object object3;
        if (!this.configured_) {
            object3 = (String)this.getServletContext().getAttribute(CONTEXT_ATTRIBUTE_PORT_MAPPINGS);
            if (object3 == null) {
                this.portMappings_ = new HashMap<Integer, PortMapping>();
                this.addPortMapping(443, 81, "https", null);
                this.addPortMapping(6443, 6081, "https", null);
                this.addPortMapping(8443, 8081, "https", null);
            } else {
                this.setPortMappings((String)object3);
            }
            this.configured_ = true;
        }
        object3 = (HttpServletRequest)object;
        HttpServletResponse httpServletResponse = (HttpServletResponse)object2;
        final PortMapping portMapping = this.portMappings_.get(object3.getLocalPort());
        if (portMapping != null) {
            URL uRL = new URL(object3.getRequestURL().toString());
            object3.getRequestURL().replace(0, object3.getRequestURL().indexOf(":"), portMapping.toScheme_);
            HttpServletRequestWrapper httpServletRequestWrapper = new HttpServletRequestWrapper((HttpServletRequest)object3){

                public int getServerPort() {
                    return portMapping.proxyPort_;
                }

                public String getScheme() {
                    return portMapping.toScheme_;
                }

                public boolean isSecure() {
                    return portMapping.isSecure();
                }
            };
            HttpServletResponseWrapper httpServletResponseWrapper = new HttpServletResponseWrapper(httpServletResponse, (HttpServletRequest)object3, (HttpServletRequest)httpServletRequestWrapper, uRL){
                final /* synthetic */ HttpServletRequest val$httpRequest;
                final /* synthetic */ HttpServletRequest val$wrappedRequest;
                final /* synthetic */ URL val$httpRequestUrl;
                {
                    this.val$httpRequest = httpServletRequest;
                    this.val$wrappedRequest = httpServletRequest2;
                    this.val$httpRequestUrl = uRL;
                    super(httpServletResponse);
                }

                public void sendRedirect(String string) throws IOException {
                    try {
                        String string2;
                        String string3 = string.toLowerCase();
                        if (string3.startsWith("http://") || string3.startsWith("https://")) {
                            string2 = string;
                        } else {
                            String string4 = this.val$httpRequest.getRequestURI();
                            StringBuilder stringBuilder = new StringBuilder();
                            String string5 = this.val$wrappedRequest.getScheme().toLowerCase();
                            stringBuilder.append(string5);
                            stringBuilder.append("://");
                            int n = -1;
                            if (string5.toLowerCase().equals("http")) {
                                n = 80;
                            } else if (string5.toLowerCase().equals("https")) {
                                n = 443;
                            }
                            stringBuilder.append(this.val$httpRequestUrl.getHost());
                            if (this.val$httpRequestUrl.getPort() != n) {
                                stringBuilder.append(":");
                                stringBuilder.append(this.val$httpRequestUrl.getPort());
                            }
                            if (string.startsWith("/")) {
                                stringBuilder.append(string);
                            } else {
                                int n2;
                                String string6 = string4.endsWith("/") ? string4 : ((n2 = string4.lastIndexOf("/")) == -1 ? "/" : string4.substring(0, n2));
                                stringBuilder.append(string6);
                                stringBuilder.append("/");
                                stringBuilder.append(string);
                            }
                            string2 = stringBuilder.toString();
                        }
                        logger.debug((Object)("redirecting to relative url = " + string + "   absolute url=" + string2));
                        super.sendRedirect(string2);
                    }
                    catch (IOException iOException) {
                        logger.error((Object)("error in responseWrapper.sendRedirect() to " + string), (Object)iOException);
                        throw new RuntimeException(iOException);
                    }
                }
            };
            object = httpServletRequestWrapper;
            object2 = httpServletResponseWrapper;
        }
        filterChain.doFilter(object, object2);
    }

    public void setPortMappings(String string) {
        this.portMappings_ = new HashMap<Integer, PortMapping>();
        Tokenizer tokenizer = new Tokenizer(string, ",");
        while (tokenizer.next()) {
            Tokenizer tokenizer2 = new Tokenizer(tokenizer.currentToken(), ":");
            int n = Integer.parseInt(tokenizer2.nextToken());
            int n2 = Integer.parseInt(tokenizer2.nextToken());
            String string2 = tokenizer2.nextToken();
            Boolean bl = null;
            if (tokenizer2.next()) {
                bl = new Boolean(tokenizer2.currentToken());
            }
            this.addPortMapping(n, n2, string2, bl);
        }
    }

    private void addPortMapping(int n, int n2, String string, Boolean bl) {
        PortMapping portMapping = new PortMapping();
        portMapping.proxyPort_ = n;
        portMapping.servletPort_ = n2;
        portMapping.toScheme_ = string;
        portMapping.isSecure_ = bl;
        this.portMappings_.put(n2, portMapping);
    }

    public static void main(String[] stringArray) {
        new HttpsProxyFilter().setPortMappings("8443:443:https");
    }

    private class PortMapping {
        private int proxyPort_;
        private int servletPort_;
        private String toScheme_;
        private Boolean isSecure_;

        private PortMapping() {
        }

        boolean isSecure() {
            if (this.isSecure_ != null) {
                return this.isSecure_;
            }
            return this.toScheme_.equalsIgnoreCase("https");
        }
    }
}

