/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.servlet.BeanSetterFilter;

public class HttpsFilter
extends BeanSetterFilter {
    private static final Logger logger = LoggerHelper.getLogger();
    public static final String CONTEXT_ATTRIBUTE_REDIRECT_PREFIX = HttpsFilter.class.getName() + ".redirectPrefix";
    private String redirectPrefix_;
    private boolean configured_ = false;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        if (!this.configured_) {
            if (this.redirectPrefix_ == null) {
                this.redirectPrefix_ = (String)this.getServletContext().getAttribute(CONTEXT_ATTRIBUTE_REDIRECT_PREFIX);
                logger.warn((Object)"no redirect prefix defined will not do any https redirecting");
            }
            this.configured_ = true;
            if (this.redirectPrefix_ != null && this.redirectPrefix_.endsWith("/")) {
                this.redirectPrefix_.substring(this.redirectPrefix_.length() - 1);
            }
        }
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            if (!servletRequest.isSecure() && this.redirectPrefix_ != null && !httpServletRequest.getRequestURL().toString().startsWith(this.redirectPrefix_)) {
                HttpServletRequest httpServletRequest2 = (HttpServletRequest)servletRequest;
                HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
                String string = httpServletRequest2.getQueryString();
                string = string == null ? "" : "?" + string;
                String string2 = this.redirectPrefix_ + httpServletRequest2.getRequestURI() + string;
                logger.trace((Object)("enforcing https redirecting to " + string2));
                httpServletResponse.sendRedirect(string2);
            } else {
                filterChain.doFilter(servletRequest, servletResponse);
            }
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public String getRedirectPrefix() {
        return this.redirectPrefix_;
    }

    public void setRedirectPrefix(String string) {
        this.redirectPrefix_ = string;
    }
}

