/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import javax.servlet.http.HttpSession;
import net.model3.chrono.DateTime;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class HtmlProcessor {
    private static final Logger logger = LoggerHelper.getLogger();
    static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "June", "July", "Aug", "Sep", "Oct", "Nov", "Dec"};
    static final String[] WEEKDAYS = new String[]{null, "Sun", "Mon", "Tue", "Wed", "Thurs", "Fri", "Sat"};

    public static String decodeParameter(String string) {
        return URLDecoder.decode(string);
    }

    public static String encodeParameter(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                stringBuffer.append(c);
                continue;
            }
            if (c < '\u0010') {
                stringBuffer.append("%0" + Integer.toHexString(c));
                continue;
            }
            if (c < '\u0100') {
                stringBuffer.append('%' + Integer.toHexString(c));
                continue;
            }
            throw new RuntimeException("don't know how to handle character " + c + " " + Integer.toHexString(c));
        }
        return stringBuffer.toString();
    }

    public static String addLineBreaks(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            StringBuffer stringBuffer = new StringBuffer(string.length());
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append("<br>");
            }
            String string3 = stringBuffer.toString();
            if (string3.length() != 0) {
                string3 = string3.substring(0, string3.length() - 4);
            }
            return string3;
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap(iOException);
        }
    }

    public static String decodeSpecialCharacters(String string) {
        if (string == null || string.indexOf("&#") == -1) {
            return string;
        }
        int n = string.length();
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            if (i + 4 < n && cArray[i] == '&' && cArray[i + 1] == '#') {
                char c;
                int n2 = 0;
                for (c = i + 2; c < n && Character.isDigit(cArray[c]); ++c) {
                    ++n2;
                }
                if (n2 > 0 && n2 <= 3 && cArray[i + 2 + n2] == ';') {
                    c = (char)Integer.parseInt(string.substring(i + 2, i + 2 + n2));
                    stringBuffer.append(c);
                    i = i + n2 + 2;
                    continue;
                }
                stringBuffer.append(cArray[i]);
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String encodeSpecialCharacters(String string) {
        return HtmlProcessor.encodeSpecialCharacters(string, "");
    }

    public static String encodeSpecialCharacters(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        if (string == null) {
            return null;
        }
        int n = string.length();
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(n);
        block10: for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (string2.indexOf(c) >= 0) {
                stringBuffer.append(c);
                continue;
            }
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == ' ') {
                stringBuffer.append(c);
                continue;
            }
            if (c >= '\u0000' && c <= '\u00ff') {
                stringBuffer.append("&#");
                stringBuffer.append((int)c);
                stringBuffer.append(";");
                continue;
            }
            switch (c) {
                case '\u2013': {
                    stringBuffer.append("&ndash;");
                    continue block10;
                }
                case '\u2014': {
                    stringBuffer.append("&mdash;");
                    continue block10;
                }
                case '\u2018': {
                    stringBuffer.append("&lsquo;");
                    continue block10;
                }
                case '\u2019': {
                    stringBuffer.append("&rsquo;");
                    continue block10;
                }
                case '\u201c': {
                    stringBuffer.append("&ldquo;");
                    continue block10;
                }
                case '\u201d': {
                    stringBuffer.append("&rdquo;");
                    continue block10;
                }
                case '\u2026': {
                    stringBuffer.append("&hellip;");
                    continue block10;
                }
                case '\u2015': 
                case '\u2016': 
                case '\u2017': 
                case '\u201a': 
                case '\u201b': 
                case '\u201e': 
                case '\u201f': 
                case '\u2020': 
                case '\u2021': 
                case '\u2022': 
                case '\u2023': 
                case '\u2024': 
                case '\u2025': {
                    logger.warn((Object)"don't know how to handle character {} = {}", (Object)Character.valueOf(c), (Object)Integer.toHexString(c));
                    stringBuffer.append("&#127;");
                }
            }
        }
        return stringBuffer.toString();
    }

    public static void clearSession(HttpSession httpSession) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = httpSession.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            arrayList.add(string);
        }
        for (String string : arrayList) {
            httpSession.removeAttribute(string);
        }
    }

    public static String formatDate(DateTime dateTime) {
        return HtmlProcessor.formatDate(dateTime, false);
    }

    public static String formatDate(DateTime dateTime, boolean bl) {
        return HtmlProcessor.formatDate(dateTime.asDate(), bl);
    }

    public static String formatDate(Date date) {
        return HtmlProcessor.formatDate(date, false);
    }

    public static String formatDate(Date date, boolean bl) {
        boolean bl2;
        boolean bl3;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        int n = gregorianCalendar2.get(5);
        gregorianCalendar2.set(11, 0);
        gregorianCalendar2.set(12, 0);
        gregorianCalendar2.set(14, 0);
        gregorianCalendar2.add(5, -6);
        int n2 = gregorianCalendar.get(1);
        int n3 = gregorianCalendar.get(2);
        int n4 = gregorianCalendar.get(5);
        int n5 = gregorianCalendar.get(10);
        int n6 = gregorianCalendar.get(11);
        int n7 = gregorianCalendar.get(12);
        int n8 = gregorianCalendar.get(7);
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            bl3 = true;
            bl2 = false;
        } else if (gregorianCalendar.before(gregorianCalendar2)) {
            bl3 = true;
            bl2 = false;
        } else if (n == n4) {
            bl3 = false;
            bl2 = false;
        } else {
            bl3 = false;
            bl2 = true;
        }
        if (bl3) {
            stringBuffer.append(MONTHS[n3]);
            stringBuffer.append(" ");
            stringBuffer.append(n4);
            stringBuffer.append(", ");
            stringBuffer.append(n2);
            stringBuffer.append(" ");
        }
        if (bl2) {
            try {
                stringBuffer.append(WEEKDAYS[n8]);
                stringBuffer.append(" ");
            }
            catch (Exception exception) {
                Exception exception2 = exception;
            }
        }
        boolean bl4 = n6 < 12;
        if (n5 == 0) {
            n5 = 12;
        }
        stringBuffer.append(n5);
        stringBuffer.append(":");
        StringX.appendNumeric(stringBuffer, n7, 2);
        if (bl4) {
            stringBuffer.append(" am");
        } else {
            stringBuffer.append(" pm");
        }
        return stringBuffer.toString();
    }

    public static String formatLinksInNewWindow(String string) {
        if (string.indexOf("<a href=\"") != -1) {
            return string.replaceAll("<a href=\"", "<a target=\"_blank\" href=\"");
        }
        return string;
    }

    public static String removeHtmlAllFormatting(String string) {
        return HtmlProcessor.removeHtml(string, false);
    }

    public static String removeHtml(String string) {
        return HtmlProcessor.removeHtml(string, true);
    }

    private static String[] getSingleLineBreakHtml() {
        String[] stringArray = new String[]{"<br>", "<br/>", "</li>", "</ol>", "</ul>"};
        return stringArray;
    }

    private static String[] getDoubleLineBreakHtml() {
        String[] stringArray = new String[]{"</p>"};
        return stringArray;
    }

    private static String removeHtml(String string, boolean bl) {
        while (string.indexOf("<") != -1) {
            int n;
            int n2;
            int n3 = string.indexOf("<");
            int n4 = string.indexOf(">") + 1;
            String string2 = string.substring(0, n3);
            String string3 = string.substring(n3, n4).replaceAll(" ", "");
            String string4 = "";
            String string5 = string.substring(n4, string.length());
            if (string3.equalsIgnoreCase("<ol>")) {
                n2 = string5.indexOf("<li>");
                int n5 = string5.indexOf("</ol>") + 5;
                String string6 = string5.substring(n2, n5);
                n = 0;
                while (string6.indexOf("<li>") != -1) {
                    string6 = string6.replaceFirst("<li>", String.valueOf(++n + ".  "));
                }
                string5 = string5.substring(0, n2) + string6 + string5.substring(n5, string5.length());
            } else if (string3.equalsIgnoreCase("<ul>")) {
                n2 = string5.indexOf("<li>");
                int n6 = string5.indexOf("</ul>") + 5;
                String string7 = string5.substring(n2, n6);
                string7 = string7.replaceAll("<li>", "* ");
                string5 = string5.substring(0, n2) + string7 + string5.substring(n6, string5.length());
            }
            n2 = 0;
            String[] stringArray = HtmlProcessor.getDoubleLineBreakHtml();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string3.equalsIgnoreCase(stringArray[i])) continue;
                string4 = bl ? "\n\n" : " ";
                n2 = 1;
                break;
            }
            if (n2 == 0) {
                String[] stringArray2 = HtmlProcessor.getSingleLineBreakHtml();
                for (n = 0; n < stringArray2.length; ++n) {
                    if (!string3.equalsIgnoreCase(stringArray2[n])) continue;
                    string4 = "\n";
                    break;
                }
            }
            string = string2 + string4 + string5;
        }
        return string;
    }
}

