/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.model3.chrono.DateTime;
import net.model3.lang.SystemX;
import net.model3.lang.ThreadScheduler;
import net.model3.lang.TimeDuration;
import net.model3.logging.LoggerHelper;
import net.model3.logging.LoggingConfigurator;
import net.model3.logging.log4j.CircularBufferAppender;
import net.model3.logging.log4j.ThreadLocalAppender;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import net.model3.newfile.PathIterator;
import net.model3.servlet.BeanSetterFilter;
import net.model3.util.SynchronizedCounter;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

@Singleton
public class ErrorReportingFilter
extends BeanSetterFilter {
    private static final net.model3.logging.Logger logger = LoggerHelper.getLogger();
    private static final SynchronizedCounter counter_ = new SynchronizedCounter();
    private DateFormat dateFormatter_ = new SimpleDateFormat("yyyyMMdd");
    private DateFormat timeFormatter_ = new SimpleDateFormat("HHmmss");
    private Directory errorReportDirectory_;
    private String prefix_;
    private int threadLocalAppenderBufferSize_ = 2048;
    private String threadLocalAppenderName_ = "servlet-error-reporting-appender";
    private ThreadLocalAppender threadLocalAppender_;
    private TimeDuration purgeFilesOlderThan_ = new TimeDuration("1 month");
    private TimeDuration purgeFilesEvery_ = new TimeDuration("1 day");
    private boolean _ignoreSocketErrors = true;
    @Inject
    Injector _injector;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        Logger logger = (Logger)ErrorReportingFilter.logger.getRoot().getDelegate();
        this.threadLocalAppender_ = (ThreadLocalAppender)logger.getAppender(this.threadLocalAppenderName_);
        if (this.threadLocalAppender_ == null) {
            ErrorReportingFilter.logger.info((Object)"adding thread local appender to logging configuration");
            this.threadLocalAppender_ = new ThreadLocalAppender();
            this.threadLocalAppender_.setName(this.threadLocalAppenderName_);
            this.threadLocalAppender_.activateOptions();
            logger.addAppender((Appender)this.threadLocalAppender_);
        } else {
            ErrorReportingFilter.logger.info((Object)"using already configured thread local appender (buffer size filter init parm is ignored)");
        }
        ThreadScheduler threadScheduler = (ThreadScheduler)this._injector.getInstance(ThreadScheduler.class);
        threadScheduler.scheduleRepeating("purge-error-reports", this.purgeFilesEvery_, false, new Runnable(){

            @Override
            public void run() {
                ErrorReportingFilter.this.purgeOldErrorReports();
            }
        });
    }

    @Override
    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        Throwable throwable;
        boolean bl;
        CircularBufferAppender circularBufferAppender;
        block7: {
            circularBufferAppender = new CircularBufferAppender();
            circularBufferAppender.setBufferSize(this.threadLocalAppenderBufferSize_);
            this.threadLocalAppender_.activateAppender((Appender)circularBufferAppender, true);
            bl = false;
            throwable = null;
            try {
                filterChain.doFilter(servletRequest, servletResponse);
                if (servletRequest.getAttribute(ErrorReportingFilter.class.getName()) != null) {
                    bl = true;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                if (this._ignoreSocketErrors && this.isSocketError(throwable)) {
                    throwable = null;
                    bl = false;
                } else {
                    bl = true;
                }
                if (!(throwable instanceof ServletException)) break block7;
                throwable = ((ServletException)throwable).getRootCause();
            }
        }
        String string = null;
        if (bl) {
            string = this.generateErrorReport(circularBufferAppender, (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, throwable);
        }
        circularBufferAppender.close();
        this.threadLocalAppender_.deactivateAppender();
        if (throwable != null) {
            throw new RuntimeException("error report generated  reportId=" + string, throwable);
        }
    }

    protected String generateErrorReport(CircularBufferAppender circularBufferAppender, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Throwable throwable) {
        Date date = new Date();
        String string = this.getPrefix() + "-error-Date" + this.dateFormatter_.format(date) + "-Time" + this.timeFormatter_.format(date) + "-" + counter_.next() + ".txt";
        try {
            Object object;
            String[] stringArray;
            Object object2;
            logger.error((Object)("error in request " + httpServletRequest.getRequestURI() + " logging details to " + string));
            Directory directory = this.getErrorReportDirectory();
            directory.makeDirectories();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println("Remote Address: " + httpServletRequest.getRemoteAddr());
            printWriter.println();
            printWriter.println("Error report " + string);
            printWriter.println();
            printWriter.println(httpServletRequest.getRequestURL());
            printWriter.println();
            printWriter.println("Request Parameters:");
            Enumeration enumeration = httpServletRequest.getParameterNames();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                stringArray = httpServletRequest.getParameterValues((String)object2);
                if (stringArray.length == 1) {
                    printWriter.println((String)object2 + "=" + (String)stringArray[0]);
                    continue;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    printWriter.println((String)object2 + "[" + i + "]=" + (String)stringArray[i]);
                }
            }
            printWriter.println();
            printWriter.println("Headers:");
            object2 = httpServletRequest.getHeaderNames();
            while (object2.hasMoreElements()) {
                stringArray = (String)object2.nextElement();
                Enumeration enumeration2 = httpServletRequest.getHeaders((String)stringArray);
                int n = 0;
                while (enumeration2.hasMoreElements()) {
                    object = (String)enumeration2.nextElement();
                    printWriter.println((String)stringArray + "[" + n + "]=" + (String)object);
                    ++n;
                }
            }
            stringArray = httpServletRequest.getSession(false);
            printWriter.println();
            if (stringArray == null) {
                printWriter.println("No Session");
            } else {
                printWriter.println("Session:   hashCode=" + SystemX.identityHexHashCode(stringArray));
                if (stringArray != null) {
                    Enumeration enumeration3 = stringArray.getAttributeNames();
                    while (enumeration3.hasMoreElements()) {
                        String string2 = (String)enumeration3.nextElement();
                        object = stringArray.getAttribute(string2);
                        printWriter.println(string2 + "=" + object);
                    }
                }
            }
            printWriter.println();
            printWriter.println("Request Attributes:");
            Enumeration enumeration4 = httpServletRequest.getAttributeNames();
            while (enumeration4.hasMoreElements()) {
                String string3 = (String)enumeration4.nextElement();
                object = httpServletRequest.getAttribute(string3);
                printWriter.println(string3 + "=" + object);
            }
            printWriter.println();
            printWriter.println("Exception:");
            throwable.printStackTrace(printWriter);
            printWriter.println();
            printWriter.println("Logs:");
            printWriter.println(circularBufferAppender.asString());
            printWriter.close();
            String string4 = stringWriter.toString();
            object = new File(directory, string).createWriter();
            ((Writer)object).write(string4);
            ((OutputStreamWriter)object).close();
        }
        catch (Throwable throwable2) {
            logger.error((Object)"error generating servlet error report", (Object)throwable2);
        }
        return string;
    }

    protected LoggingConfigurator getLoggingConfigurator() {
        return (LoggingConfigurator)this._injector.getInstance(LoggingConfigurator.class);
    }

    protected Directory getErrorReportDirectory() {
        if (this.errorReportDirectory_ == null) {
            this.setErrorReportDirectory(new Directory(this.getLoggingConfigurator().getLogDirectory(), "webapp-errors"));
        }
        return this.errorReportDirectory_;
    }

    public void setErrorReportDirectory(Directory directory) {
        this.errorReportDirectory_ = directory;
        this.errorReportDirectory_.makeDirectories();
    }

    public void setThreadLocalAppenderBufferSize(int n) {
        this.threadLocalAppenderBufferSize_ = n;
    }

    public void setThreadLocalAppenderName(String string) {
        this.threadLocalAppenderName_ = string;
    }

    public String getPrefix() {
        if (this.prefix_ == null) {
            this.prefix_ = this.getLoggingConfigurator().getPrefix();
        }
        return this.prefix_;
    }

    public void setPrefix(String string) {
        this.prefix_ = string;
    }

    void purgeOldErrorReports() {
        if (!this.getErrorReportDirectory().exists()) {
            return;
        }
        DateTime dateTime = new DateTime().subtract(this.purgeFilesOlderThan_);
        PathIterator pathIterator = new PathIterator(this.getErrorReportDirectory(), "error-Date*-Time*-*.txt");
        for (File file : pathIterator.listFiles()) {
            if (!file.getLastModified().lessThan(dateTime)) continue;
            try {
                file.delete();
            }
            catch (Exception exception) {
                logger.debug((Object)"purgeOldErrorReports()", (Object)exception);
            }
        }
    }

    boolean isSocketError(Throwable throwable) {
        String string;
        SocketException socketException = null;
        if (throwable.getClass().equals(SocketException.class)) {
            socketException = (SocketException)throwable;
        } else if (throwable.getCause() != null && throwable.getCause().getClass().equals(SocketException.class)) {
            socketException = (SocketException)throwable.getCause();
        }
        return socketException != null && ((string = socketException.getMessage()).contains("Broken Pipe") || string.contains("Conection Reset"));
    }
}

