/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet;

import net.model3.util.Tokenizer;

public class BrowserProperties {
    static final String GECKO = "gecko";
    static final String MSIE = "msie";
    static final String MOZILLAX = "mozilla";
    static final String MOZILLA = "mozilla/";
    static final String OPERA = "opera";
    static final String AOL = "aol";
    private static final int MAXIMUM_URL_LENGTH = 2048;
    private String userAgent_;

    public BrowserProperties(String string) {
        if (string == null) {
            string = "";
        }
        this.userAgent_ = string.toLowerCase();
    }

    public static void main(String[] stringArray) throws Exception {
    }

    static String[] getAttributes(char c, char c2, String string) {
        int n = string.indexOf(c);
        if (n < 0) {
            return new String[0];
        }
        int n2 = string.indexOf(c2);
        if (n2 < n) {
            throw new RuntimeException("user-agent: " + string + " openChar: " + c + "  open char after close char or no close char");
        }
        String string2 = string.substring(n + 1, n2);
        Tokenizer tokenizer = new Tokenizer(string2, ";", false);
        return tokenizer.getAllTokens(true);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.userAgent_);
        stringBuffer.append('\n');
        stringBuffer.append("      mozilla maj " + this.getMozillaMajorVersion() + " min " + this.getMozillaMinorVersion());
        stringBuffer.append('\n');
        stringBuffer.append("      ie maj " + this.getInternetExplorerMajorVersion() + " min " + this.getInternetExplorerMinorVersion());
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public boolean isInternetExplorer() {
        return this.userAgentContains(MSIE);
    }

    public boolean isInternetExplorer5() {
        return this.getInternetExplorerMajorVersion() == 5;
    }

    public boolean isInternetExplorer6() {
        return this.getInternetExplorerMajorVersion() >= 6;
    }

    public int getInternetExplorerMajorVersion() {
        return this.getMajorVersionNumber(MSIE);
    }

    public int getInternetExplorerMinorVersion() {
        return this.getMinorVersionNumber(MSIE);
    }

    public boolean isMacintosh() {
        return this.userAgentContains("mac");
    }

    public boolean isWindows() {
        return this.userAgentContains("win");
    }

    public boolean isLinux() {
        return this.userAgentContains("linux");
    }

    public boolean isAol() {
        return this.userAgentContains(AOL);
    }

    public int getAolMajorVersion() {
        return this.getMajorVersionNumber(AOL);
    }

    public int getAolMinorVersion() {
        return this.getMinorVersionNumber(AOL);
    }

    public boolean isOpera() {
        return this.userAgentContains(OPERA);
    }

    public int getOperaMajorVersion() {
        return this.getMajorVersionNumber(OPERA);
    }

    public int getOperaMinorVersion() {
        return this.getMinorVersionNumber(OPERA);
    }

    boolean isMozillaCompatible() {
        return this.userAgentContains(MOZILLA);
    }

    public int getMozillaMajorVersion() {
        return this.getMajorVersionNumber(MOZILLAX);
    }

    public int getMozillaMinorVersion() {
        return this.getMinorVersionNumber(MOZILLAX);
    }

    public boolean isGecko() {
        return this.userAgentContains(GECKO);
    }

    public boolean isMozilla() {
        return this.userAgentContains(GECKO);
    }

    public boolean isMozilla1_3Up() {
        if (this.userAgentContains("rv:")) {
            int n = this.userAgent_.indexOf("rv:") + 3;
            String string = this.userAgent_.substring(n);
            int n2 = 0;
            int n3 = string.indexOf(" ");
            int n4 = string.indexOf(")");
            int n5 = string.indexOf(";");
            if (!(n3 <= 0 || n3 >= n4 && n4 >= 0 || n3 >= n5 && n5 >= 0)) {
                n2 = n3;
            } else if (!(n4 <= 0 || n4 >= n3 && n3 >= 0 || n4 >= n5 && n5 >= 0)) {
                n2 = n4;
            } else if (!(n5 <= 0 || n5 >= n3 && n3 >= 0 || n5 >= n4 && n4 >= 0)) {
                n2 = n5;
            }
            string = string.substring(0, n2);
            int n6 = string.indexOf(".");
            int n7 = 0;
            if (n6 >= 0) {
                n7 = string.indexOf(".", n6 + 1);
            }
            if (n7 >= 0) {
                string = string.substring(0, n7);
            }
            try {
                float f = Float.parseFloat(string);
                if ((double)f >= 1.3) {
                    return true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    public boolean isNetscape6() {
        return this.isGecko();
    }

    public boolean isUnsupported() {
        return this.isNetscape4_7() || this.isNetscape6() || this.isInternetExplorer5();
    }

    public boolean isNetscape4_7() {
        return this.isNetscape() && this.getMozillaMajorVersion() == 4 && this.getMozillaMinorVersion() >= 7;
    }

    public boolean isNetscape7() {
        return this.isNetscape() && this.userAgentContains("netscape/7");
    }

    public boolean isNetscape() {
        return this.isMozillaCompatible() && !this.userAgentContains("compatible");
    }

    public int getMaximumUrlLength() {
        return 2048;
    }

    public boolean isMoz() {
        return this.isMozilla();
    }

    public Object getDataModelValue(String string) {
        if (string.equalsIgnoreCase(AOL)) {
            return new Boolean(this.isAol());
        }
        if (string.equalsIgnoreCase("unsupported")) {
            return new Boolean(this.isUnsupported());
        }
        if (string.equalsIgnoreCase("mozilla_major_version")) {
            return new Integer(this.getMozillaMajorVersion());
        }
        if (string.equalsIgnoreCase("mozilla_minor_version")) {
            return new Integer(this.getMozillaMinorVersion());
        }
        if (string.equalsIgnoreCase("moz")) {
            return new Boolean(this.isMozilla());
        }
        if (string.equalsIgnoreCase("moz1_3")) {
            return new Boolean(this.isMozilla1_3Up());
        }
        if (string.equalsIgnoreCase("ns4_7")) {
            return new Boolean(this.isNetscape4_7());
        }
        if (string.equalsIgnoreCase("ns6")) {
            return new Boolean(this.isNetscape6());
        }
        if (string.equalsIgnoreCase("ie")) {
            return new Boolean(this.isInternetExplorer());
        }
        if (string.equalsIgnoreCase("ie5")) {
            return new Boolean(this.isInternetExplorer5());
        }
        if (string.equalsIgnoreCase("ie6")) {
            return new Boolean(this.isInternetExplorer6());
        }
        if (string.equalsIgnoreCase("ie6_win")) {
            return new Boolean(this.isInternetExplorer6() && this.isWindows());
        }
        if (string.equalsIgnoreCase("ie_win")) {
            return new Boolean(this.isInternetExplorer() && this.isWindows());
        }
        if (string.equalsIgnoreCase("ieMac5_1")) {
            if (this.isMacintosh() && this.getInternetExplorerMajorVersion() >= 5 && this.getInternetExplorerMinorVersion() >= 1) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }
        if (string.equalsIgnoreCase("mac")) {
            return new Boolean(this.isMacintosh());
        }
        if (string.equalsIgnoreCase("win")) {
            return new Boolean(this.isWindows());
        }
        if (string.equalsIgnoreCase(OPERA)) {
            return new Boolean(this.isOpera());
        }
        if (string.equalsIgnoreCase("user-agent")) {
            return this.userAgent_;
        }
        throw new RuntimeException("key " + string + " not found");
    }

    private boolean userAgentContains(String string) {
        return this.userAgent_.toLowerCase().indexOf(string.toLowerCase()) >= 0;
    }

    private int getMajorVersionNumber(String string) {
        int n = this.userAgent_.indexOf(string);
        if (n < 0) {
            return -1;
        }
        char c = this.userAgent_.charAt(n += string.length() + 1);
        if (Character.isDigit(c)) {
            return Character.getNumericValue(c);
        }
        return -1;
    }

    private int getMinorVersionNumber(String string) {
        int n = this.userAgent_.indexOf(string);
        if (n < 0) {
            return -1;
        }
        char c = this.userAgent_.charAt(n += string.length() + 3);
        if (Character.isDigit(c)) {
            return Character.getNumericValue(c);
        }
        return -1;
    }

    private int getMinorVersionNumber(int n) {
        char c = this.userAgent_.charAt(n + 2);
        if (Character.isDigit(c)) {
            return Character.getNumericValue(c);
        }
        return -1;
    }

    public boolean isInternetExplorer6Windows() {
        return this.isInternetExplorer6() && this.isWindows();
    }
}

