/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet;

import java.util.Enumeration;
import javax.servlet.ServletException;
import net.model3.bean.ReflectionTool;
import net.model3.bean.ReflectionToolException;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.servlet.BaseServlet;

public abstract class BeanSetterServlet
extends BaseServlet {
    private static final long serialVersionUID = 865428894517488558L;
    private static final Logger logger = LoggerHelper.getLogger(BeanSetterServlet.class);
    private static final ReflectionTool beanTool_ = new ReflectionTool();
    private boolean initParmsMustHaveSetter_ = true;
    private boolean autoSetInitParms_ = true;

    public void init() throws ServletException {
        try {
            if (this.getAutoSetInitParms()) {
                this.processInitParmAutoSetting();
            }
        }
        catch (ReflectionToolException reflectionToolException) {
            logger.fatal((Object)"error initializing servlet", (Object)reflectionToolException);
            throw reflectionToolException;
        }
    }

    protected void setAutoSetInitParms(boolean bl) {
        this.autoSetInitParms_ = bl;
    }

    protected boolean getAutoSetInitParms() {
        return this.autoSetInitParms_;
    }

    protected boolean getInitParmsMustHaveSetter() {
        return this.initParmsMustHaveSetter_;
    }

    protected void setInitParmsMustHaveSetter(boolean bl) {
        this.initParmsMustHaveSetter_ = bl;
    }

    private void processInitParmAutoSetting() throws ReflectionToolException {
        if (!this.getAutoSetInitParms()) {
            throw new RuntimeException("cannot process bean setters when getAutoSetInitParms() is false");
        }
        Enumeration enumeration = this.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.getInitParameter(string);
            beanTool_.setBeanProperty((Object)this, string, string2);
        }
    }
}

