/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet;

import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import net.model3.bean.ReflectionTool;
import net.model3.bean.ReflectionToolException;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public abstract class BeanSetterFilter
implements Filter {
    private static final Logger logger = LoggerHelper.getLogger(BeanSetterFilter.class);
    private static final ReflectionTool beanTool_ = new ReflectionTool();
    private ServletContext servletContext_;

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.servletContext_ = filterConfig.getServletContext();
            if (this.getAutoSetInitParms()) {
                this.processInitParmAutoSetting(filterConfig);
            }
        }
        catch (ReflectionToolException reflectionToolException) {
            logger.fatal((Object)"error initializing filter", (Object)reflectionToolException);
            throw new ServletException((Throwable)reflectionToolException);
        }
    }

    protected boolean getAutoSetInitParms() {
        return true;
    }

    protected boolean getInitParmsMustHaveSetter() {
        return true;
    }

    private void processInitParmAutoSetting(FilterConfig filterConfig) throws ReflectionToolException {
        if (!this.getAutoSetInitParms()) {
            throw new RuntimeException("cannot process bean setters when getAutoSetInitParms() is false");
        }
        Enumeration enumeration = filterConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = filterConfig.getInitParameter(string);
            beanTool_.setBeanProperty((Object)this, string, string2);
        }
    }

    public void destroy() {
    }

    public ServletContext getServletContext() {
        return this.servletContext_;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext_ = servletContext;
    }
}

