/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet;

import java.util.HashMap;
import java.util.Map;
import net.model3.servlet.Action;
import net.model3.servlet.ActionFactory;

public class ActionFactoryRegistry {
    private static final ActionFactoryRegistry instance_ = new ActionFactoryRegistry();
    private Map<Class<? extends Action>, ActionFactory> actionClassToActionFactoryMap_ = new HashMap<Class<? extends Action>, ActionFactory>();
    private Map<Class<? extends ActionFactory>, ActionFactory> actionFactoryClassToActionFactoryMap_ = new HashMap<Class<? extends ActionFactory>, ActionFactory>();

    public static ActionFactoryRegistry getInstance() {
        return instance_;
    }

    public ActionFactory getActionFactory(Action action) {
        ActionFactory actionFactory = this.actionClassToActionFactoryMap_.get(action.getClass());
        if (actionFactory != null) {
            return actionFactory;
        }
        throw new RuntimeException("action factory not found for " + action.getClass());
    }

    public ActionFactory getActionFactory(Class<? extends ActionFactory> clazz) {
        ActionFactory actionFactory = this.actionFactoryClassToActionFactoryMap_.get(clazz);
        if (actionFactory != null) {
            return actionFactory;
        }
        throw new RuntimeException("action factory not found for " + clazz.getName());
    }

    public void register(ActionFactory actionFactory) {
        this.actionFactoryClassToActionFactoryMap_.put(actionFactory.getClass(), actionFactory);
        for (Action action : actionFactory.getActions()) {
            this.actionClassToActionFactoryMap_.put(action.getClass(), actionFactory);
        }
    }
}

