/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.model3.bean.ReflectionTool;
import net.model3.collections.CaseInsensitiveMapWrapper;
import net.model3.lang.ClassX;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.ModifierX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.model3.servlet.Action;
import net.model3.servlet.ActionFactoryRegistry;
import net.model3.servlet.TemplateFactory;

public abstract class ActionFactory {
    private static final Logger logger = LoggerHelper.getLogger();
    private Map<String, Action> actionMap_ = new CaseInsensitiveMapWrapper<Action>();
    private TemplateFactory templateFactory_;
    private ServletContext servletContext_;
    private ReflectionTool reflectionTool_;
    private String actionPrefix_;
    private Set<Integer> httpsPorts_ = new HashSet<Integer>();
    private boolean underscoreActionNames_ = true;

    public ActionFactory() {
        this.httpsPorts_.add(443);
        this.httpsPorts_.add(6443);
        this.httpsPorts_.add(8443);
        this.setActionPrefix("action");
    }

    boolean isHttpsPort(int n) {
        return this.httpsPorts_.contains(n);
    }

    public void loadActionClassesInPackage(Class clazz) {
        for (Class<?> clazz2 : ClassX.getClassesInPackage(clazz)) {
            if (ModifierX.ABSTRACT.isIn(clazz2.getModifiers()) || !ClassX.isAssignable(Action.class, clazz2)) continue;
            try {
                Action action = (Action)clazz2.newInstance();
                this.addAction(action);
            }
            catch (Exception exception) {
                logger.warn((Object)"unable to load action class {}", (Object)clazz2.getName(), (Object)exception);
            }
        }
    }

    protected void addAction(Action action) {
        action.setActionFactory(this);
        logger.debug((Object)"added action {}  -  {}", (Object)action.getName(), (Object)action.getClass().getName());
        this.actionMap_.put(action.getName(), action);
    }

    public Action createInstance(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Class clazz = this.getActionClass(string);
        if (clazz == null) {
            return null;
        }
        try {
            Action action = (Action)clazz.newInstance();
            action.setActionFactory(this);
            return action;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public Collection<Action> getActions() {
        return this.actionMap_.values();
    }

    protected Class getActionClass(String string) {
        Action action = this.actionMap_.get(string);
        if (action == null) {
            return null;
        }
        return action.getClass();
    }

    public TemplateFactory getTemplateFactory() {
        return this.templateFactory_;
    }

    public void setTemplateFactory(TemplateFactory templateFactory) {
        this.templateFactory_ = templateFactory;
    }

    public ServletContext getServletContext() {
        return this.servletContext_;
    }

    protected final void init(ServletContext servletContext) {
        this.servletContext_ = servletContext;
        this.initImpl();
        ActionFactoryRegistry.getInstance().register(this);
        if (this.getActionPrefix() == null) {
            throw new RuntimeException(this.getClass().getName() + " must set actionPrefix");
        }
    }

    protected void initImpl() {
    }

    public Directory getErrorReportDirectory() {
        String string = this.getServletContext().getRealPath("./WEB-INF/logs/");
        return new Directory(string);
    }

    protected void initReflectionTool() {
        this.setReflectionTool(new ReflectionTool(false));
    }

    public ReflectionTool getReflectionTool() {
        if (this.reflectionTool_ == null) {
            this.initReflectionTool();
        }
        return this.reflectionTool_;
    }

    public void setReflectionTool(ReflectionTool reflectionTool) {
        this.reflectionTool_ = reflectionTool;
    }

    public String getActionPrefix() {
        return this.actionPrefix_;
    }

    public void setActionPrefix(String string) {
        logger.debug((Object)("action prefix set to " + string + " for " + this));
        this.actionPrefix_ = string;
    }
}

