/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet;

import com.google.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.servlet.Action;
import net.model3.servlet.ActionFactory;
import net.model3.servlet.BeanSetterServlet;
import net.model3.servlet.WebApp;
import net.model3.servlet.WebRequest;

@Singleton
public class ActionDispatchServlet
extends BeanSetterServlet {
    private static final long serialVersionUID = -772024240970938041L;
    private static final Logger logger = LoggerHelper.getLogger();
    private String actionFactoryName_;
    private ActionFactory actionFactory_;
    private WebApp webApp_;

    @Override
    public void init() throws ServletException {
        try {
            super.init();
            try {
                this.actionFactory_ = (ActionFactory)DependencyInjector.get().getInstance(ActionFactory.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.actionFactory_ == null) {
                if (this.actionFactoryName_ == null) {
                    throw new ServletException("actionFactoryName must be set OR provide an ActionFactory instance via guice");
                }
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.actionFactoryName_);
                this.actionFactory_ = (ActionFactory)clazz.newInstance();
            }
            this.actionFactory_.init(this.getServletContext());
            this.webApp_ = WebApp.getImpl();
        }
        catch (Throwable throwable) {
            logger.fatal((Object)"unable to initialize servlet", (Object)throwable);
            throw ExceptionPropagator.wrap(throwable);
        }
    }

    @Override
    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        String string;
        String string2;
        httpServletResponse.setHeader("Cache-Control", "no-cache, must-revalidate, max_age=0");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setHeader("Expires", "0");
        String string3 = httpServletRequest.getPathInfo().length() > 0 ? httpServletRequest.getPathInfo().substring(1) : "";
        int n = string3.indexOf(47);
        if (n >= 0) {
            string2 = string3.substring(n + 1);
            string = string3.substring(0, n);
        } else {
            string2 = null;
            string = string3;
        }
        HttpServletRequest httpServletRequest2 = null;
        HttpServletResponse httpServletResponse2 = null;
        boolean bl = false;
        Object t = WebRequest.getImpl();
        if (t == null) {
            bl = true;
            this.webApp_.requestStarted((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, false);
        } else {
            httpServletRequest2 = ((WebRequest)t).getHttpServletRequest();
            httpServletResponse2 = ((WebRequest)t).getHttpServletResponse();
            ((WebRequest)t).init((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        try {
            Action action = this.actionFactory_.createInstance(string, httpServletRequest, httpServletResponse);
            if (action != null) {
                action.setSuffix(string2);
                logger.debug((Object)httpServletRequest.getRequestURI());
                action.process();
            } else {
                logger.warn((Object)"action {} not found", (Object)string);
                httpServletResponse.sendError(404);
            }
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
        finally {
            if (bl) {
                this.webApp_.requestEnded();
            } else {
                ((WebRequest)t).init((ServletRequest)httpServletRequest2, (ServletResponse)httpServletResponse2);
            }
        }
    }

    public void setActionFactory(String string) {
        this.actionFactoryName_ = string;
    }

    public ActionFactory getActionFactory() {
        return this.actionFactory_;
    }
}

