/*
 * Decompiled with CFR 0.152.
 */
package net.model3.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.model3.bean.ClassHelper;
import net.model3.bean.Property;
import net.model3.bean.PropertyHelper;
import net.model3.bean.PropertyNotFoundException;
import net.model3.bean.ReflectionTool;
import net.model3.bean.ReflectionToolException;
import net.model3.collections.ArrayX;
import net.model3.collections.CaseInsensitiveMapWrapper;
import net.model3.collections.SetX;
import net.model3.lang.ClassX;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.SystemX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.servlet.ActionFactory;
import net.model3.servlet.ActionFactoryRegistry;
import net.model3.servlet.BrowserProperties;
import net.model3.servlet.HtmlProcessor;
import net.model3.servlet.ParmExcludeFromUrl;
import net.model3.servlet.RedirectToUrlProcessEscape;
import net.model3.servlet.Template;
import net.model3.servlet.WebRequest;
import net.model3.util.Tokenizer;

public abstract class Action {
    private static final Logger logger = LoggerHelper.getLogger(Action.class);
    private static final Set<String> defaultExcludeParms = Collections.unmodifiableSet(SetX.create("suffix"));
    private WebRequest webRequest_;
    private ActionFactory actionFactory_;
    private String name_;
    private String suffix_;
    private RedirectToUrlProcessEscape redirectToUrlProcessEscape_;
    private String contentType_;
    private boolean inProcess_ = false;
    private List<String> requiredProperties_;
    private CaseInsensitiveMapWrapper<String[]> parameterMap_;

    public WebRequest getWebRequest() {
        if (this.webRequest_ == null) {
            this.webRequest_ = WebRequest.getImpl();
        }
        return this.webRequest_;
    }

    public String getName() {
        if (this.name_ == null) {
            this.name_ = this.initName();
        }
        return this.name_;
    }

    protected String initName() {
        String string = ClassX.getShortName(this.getClass());
        StringBuilder stringBuilder = new StringBuilder();
        if (string.endsWith("Action")) {
            string = string.substring(0, string.length() - "Action".length());
        }
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 != (c = Character.toLowerCase(c2)) && i > 0 && !bl) {
                stringBuilder.append('_');
                bl = true;
            } else {
                bl = false;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Object getRequestAsHtmlString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<br>context-path: " + this.getRequest().getContextPath());
        stringBuffer.append("<br>method: " + this.getRequest().getMethod());
        stringBuffer.append("<br>path-info: " + this.getRequest().getPathInfo());
        stringBuffer.append("<br>path-translated: " + this.getRequest().getPathTranslated());
        stringBuffer.append("<br>protocol: " + this.getRequest().getProtocol());
        stringBuffer.append("<br>query-string: " + this.getRequest().getQueryString());
        stringBuffer.append("<br>remote-addr: " + this.getRequest().getRemoteAddr());
        stringBuffer.append("<br>remote-host: " + this.getRequest().getRemoteHost());
        stringBuffer.append("<br>remote-user: " + this.getRequest().getRemoteUser());
        stringBuffer.append("<br>session-id: " + this.getRequest().getRequestedSessionId());
        stringBuffer.append("<br>request-uri: " + this.getRequest().getRequestURI());
        stringBuffer.append("<br>request-url: " + this.getRequest().getRequestURL());
        stringBuffer.append("<br>scheme: " + this.getRequest().getScheme());
        stringBuffer.append("<br>server-name: " + this.getRequest().getServerName());
        stringBuffer.append("<br>server-port: " + this.getRequest().getServerPort());
        stringBuffer.append("<br>servlet-path: " + this.getRequest().getServletPath());
        stringBuffer.append("<br>session-from-cookie: " + this.getRequest().isRequestedSessionIdFromCookie());
        stringBuffer.append("<br>session-from-url: " + this.getRequest().isRequestedSessionIdFromURL());
        stringBuffer.append("<br>secure: " + this.getRequest().isSecure());
        return stringBuffer.toString();
    }

    public String getServletPath() {
        return this.getRequest().getServletPath();
    }

    public String getUrl() {
        String string = this.getSuffix() == null ? "" : "/" + this.getSuffix();
        String string2 = this.getBaseUrl() + '/' + this.getName() + string;
        return string2;
    }

    public String getBaseUrl() {
        String string = this.getContextPath() + "/" + this.getActionFactory().getActionPrefix();
        return string;
    }

    @ParmExcludeFromUrl
    public String getContentType() {
        return this.contentType_;
    }

    public void outputHtml() {
        if (this.getContentType() == null) {
            this.setContentType("text/html");
        }
        this.outputHtml(this);
    }

    public void outputHtml(Object object) {
        try {
            if (this.getContentType() == null) {
                this.setContentType("text/html");
            }
            this.getResponse().setContentType("text/html");
            ServletOutputStream servletOutputStream = this.getResponse().getOutputStream();
            this.getTemplate().write((OutputStream)servletOutputStream, object);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Template getTemplate() {
        return this.getActionFactory().getTemplateFactory().getTemplate(this.getName() + ".html");
    }

    public String getContextPath() {
        return this.getRequest().getContextPath();
    }

    public void setHeadersForNoCaching() {
        this.getResponse().setHeader("Cache-Control", "no-cache, must-revalidate, max_age=0");
        this.getResponse().setHeader("Pragma", "no-cache");
        this.getResponse().setHeader("Expires", "0");
    }

    public void process() {
        this.inProcess_ = true;
        try {
            this.initialize();
            this.processRequestParmAutoSetting(this.getParameterMap());
            this.dispatch();
            this.commit();
            this.completed();
        }
        catch (Throwable throwable) {
            try {
                this.rollback(throwable);
            }
            catch (Exception exception) {
                logger.error((Object)"error during rollback", (Object)exception);
            }
            throw ExceptionPropagator.wrap(throwable);
        }
        if (this.redirectToUrlProcessEscape_ != null) {
            try {
                this.getResponse().sendRedirect(this.redirectToUrlProcessEscape_.getUrl());
            }
            catch (IOException iOException) {
                logger.error((Object)"error redirecting to {}", (Object)this.redirectToUrlProcessEscape_.getUrl(), (Object)iOException);
            }
        }
    }

    public void dispatchToAction(Action action) {
        action.dispatch();
    }

    protected void dispatch() {
        this.inProcess_ = true;
        try {
            logger.trace((Object)("dispatch action start  action=" + this.getName()));
            this.validate();
            this.execute();
            logger.trace((Object)("dispatch action complete  action=" + this.getName()));
        }
        catch (RedirectToUrlProcessEscape redirectToUrlProcessEscape) {
            this.redirectToUrlProcessEscape_ = redirectToUrlProcessEscape;
            logger.debug((Object)("Process escape: " + redirectToUrlProcessEscape.getMessage()));
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    @Deprecated
    protected final String getLoggingContext() {
        return this.getName() + "@" + SystemX.identityHexHashCode(this);
    }

    protected void completed() {
    }

    protected void commit() {
    }

    protected void setContentType(String string) {
        if (this.contentType_ != null) {
            if (!this.contentType_.equals(string)) {
                logger.warn((Object)("content type already set '" + this.getResponse().getContentType() + "' cannot set to '" + string + "'"), (Object)new Throwable());
            }
        } else {
            this.contentType_ = string;
            this.getResponse().setContentType(string);
        }
    }

    protected abstract void validate() throws Exception;

    protected abstract void execute() throws Exception;

    @Deprecated
    protected final void rollback() {
    }

    protected void rollback(Throwable throwable) {
    }

    protected void initialize() {
    }

    public ReflectionTool getBeanTool() {
        return this.getActionFactory().getReflectionTool();
    }

    public String getParmsAsHiddenFields() {
        return this.getParmsAsHiddenFields("");
    }

    public String getParmsAsHiddenFields(String string) {
        Tokenizer tokenizer = new Tokenizer(string, ",:");
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : tokenizer.getAllTokens()) {
            hashSet.add(string2);
        }
        return this.processParametersWithoutAnnotationExclusions(hashSet, new PropertyProcessor(){

            @Override
            public void processProperty(StringBuilder stringBuilder, Property property, String string) {
                stringBuilder.append("<input type=\"hidden\" name=\"");
                stringBuilder.append(property.name());
                stringBuilder.append("\" value=\"");
                stringBuilder.append(HtmlProcessor.encodeSpecialCharacters(string));
                stringBuilder.append("\" />");
                stringBuilder.append("\n");
            }
        });
    }

    public String getUrlWithParms(String string) {
        Tokenizer tokenizer = new Tokenizer(string, ",:");
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : tokenizer.getAllTokens()) {
            hashSet.add(string2);
        }
        return this.getUrlWithParms(hashSet);
    }

    String processParametersWithoutAnnotationExclusions(Set<String> set, PropertyProcessor propertyProcessor) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Property property : this.getBeanTool().getClassHelper(this.getClass()).getPropertyList()) {
            String string;
            if (property.getter() == null || property.setter() == null || !this.usePropertyOnRedirect(property) || set.contains(property.name())) continue;
            try {
                string = this.getBeanTool().getBeanPropertyAsString(this, property.name());
            }
            catch (Exception exception) {
                throw new RuntimeException("unable to retrieve property " + property + " from " + this.getClass().getName(), exception);
            }
            if (string == null) continue;
            propertyProcessor.processProperty(stringBuilder, property, string);
        }
        return stringBuilder.toString();
    }

    public String getUrlWithParms() {
        return this.getUrlWithParms(defaultExcludeParms);
    }

    public String getUrlWithParms(Set<String> set) {
        String string = this.getParmsAsUrlQueryString(set);
        String string2 = "";
        if (string.length() > 0) {
            string2 = "?";
        }
        return this.getUrl() + string2 + string;
    }

    public String getParmsAsUrlQueryString() {
        return this.getParmsAsUrlQueryString(null);
    }

    public String getParmsAsUrlQueryString(Set<String> set) {
        if (set == null) {
            set = SetX.emptySet();
        }
        String string = this.processParametersWithoutAnnotationExclusions(set, new PropertyProcessor(){

            @Override
            public void processProperty(StringBuilder stringBuilder, Property property, String string) {
                if (string != null) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("&");
                    }
                    stringBuilder.append(property.name());
                    stringBuilder.append("=");
                    stringBuilder.append(HtmlProcessor.encodeParameter(string));
                }
            }
        });
        return string;
    }

    protected void redirectToAction(Action action) {
        this.redirectToUrl(action.getUrlWithParms());
    }

    protected void redirectToUrl(String string) {
        logger.trace((Object)("throwing RedirectToUrlProcessEscape error url=" + string));
        throw new RedirectToUrlProcessEscape(string);
    }

    protected void setHeader(String string, String string2) {
        this.getResponse().setHeader(string, string2);
    }

    public HttpServletResponse getResponse() {
        return this.getWebRequest().getHttpServletResponse();
    }

    public HttpServletRequest getRequest() {
        return this.getWebRequest().getHttpServletRequest();
    }

    public BrowserProperties getBrowser() {
        return ((WebRequest)WebRequest.getImpl()).getBrowserProperties();
    }

    public String getUserAgent() {
        return ((WebRequest)WebRequest.getImpl()).getUserAgent();
    }

    @ParmExcludeFromUrl
    protected CaseInsensitiveMapWrapper<String[]> getParameterMap() {
        if (this.parameterMap_ == null) {
            this.parameterMap_ = this.initParameterMap();
        }
        return this.parameterMap_;
    }

    protected CaseInsensitiveMapWrapper<String[]> initParameterMap() {
        Map map = this.getRequest().getParameterMap();
        CaseInsensitiveMapWrapper<String[]> caseInsensitiveMapWrapper = new CaseInsensitiveMapWrapper<String[]>();
        for (Object k : map.keySet()) {
            String string = (String)k;
            String[] stringArray = this.getRequest().getParameterValues(string);
            caseInsensitiveMapWrapper.put(string, stringArray);
        }
        return caseInsensitiveMapWrapper;
    }

    public void processRequestParmAutoSetting(CaseInsensitiveMapWrapper<String[]> caseInsensitiveMapWrapper) throws ReflectionToolException {
        try {
            this.setParameterMap(caseInsensitiveMapWrapper);
            Set<String> set = SetX.create(caseInsensitiveMapWrapper.keySet());
            ClassHelper classHelper = this.getBeanTool().getClassHelper(this);
            for (Property object : classHelper.getProperties().values()) {
                String string = object.name().toLowerCase();
                if (!caseInsensitiveMapWrapper.containsKey(string)) continue;
                set.remove(string);
                this.invokePropertySetter(object, caseInsensitiveMapWrapper);
            }
            for (String string : set) {
                if (!this.throwPropertyNotFoundException(string, caseInsensitiveMapWrapper.get(set))) continue;
                throw new PropertyNotFoundException("property " + string + " not found in " + this.getClass().getName());
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            logger.trace((Object)"Property not found listing valid properties");
            logger.trace((Object)"    bean tool   case insensitive={}", (Object)this.getBeanTool().isCaseSensitive());
            for (Property property : this.getBeanTool().getClassHelper(this.getClass()).getPropertyList()) {
                logger.trace((Object)"    {} - {}", (Object)property.name(), (Object)property.type().getName());
            }
            logger.trace((Object)"{} see previous messages for valid properties", (Object)propertyNotFoundException.getMessage());
            throw propertyNotFoundException;
        }
    }

    protected void invokePropertySetter(Property<Object, Object> property, CaseInsensitiveMapWrapper<String[]> caseInsensitiveMapWrapper) {
        String string = property.name().toLowerCase();
        if (!caseInsensitiveMapWrapper.containsKey(string)) {
            return;
        }
        String[] stringArray = caseInsensitiveMapWrapper.get(string);
        if (stringArray != null) {
            try {
                PropertyHelper.setPropertyFromStringArray(this.getBeanTool(), property, this, stringArray);
            }
            catch (Exception exception) {
                String string2 = "unable to set " + this.getClass().getName() + "." + property + "=" + ArrayX.toString(stringArray);
                logger.error((Object)string2, (Object)exception);
                throw new RuntimeException(string2, exception);
            }
        }
    }

    @ParmExcludeFromUrl
    protected ActionFactory getActionFactory() {
        if (this.actionFactory_ == null) {
            this.actionFactory_ = ActionFactoryRegistry.getInstance().getActionFactory(this);
        }
        return this.actionFactory_;
    }

    void setActionFactory(ActionFactory actionFactory) {
        this.actionFactory_ = actionFactory;
    }

    public String toString() {
        return this.getName() + "@" + Integer.toHexString(System.identityHashCode(this));
    }

    public Object getDataModelRoot() {
        return this;
    }

    protected boolean throwPropertyNotFoundException(String string, String[] stringArray) {
        return true;
    }

    protected boolean usePropertyOnRedirect(Property property) {
        ParmExcludeFromUrl parmExcludeFromUrl = PropertyHelper.getAnnotation(property, ParmExcludeFromUrl.class);
        return parmExcludeFromUrl == null;
    }

    protected void setParameterMap(CaseInsensitiveMapWrapper<String[]> caseInsensitiveMapWrapper) {
        this.parameterMap_ = caseInsensitiveMapWrapper;
    }

    public boolean isInProcess() {
        return this.inProcess_;
    }

    public PrintWriter getWriter() {
        try {
            return this.getResponse().getWriter();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String getSuffix() {
        return this.suffix_;
    }

    public void setSuffix(String string) {
        this.suffix_ = string;
    }

    static interface PropertyProcessor {
        public void processProperty(StringBuilder var1, Property var2, String var3);
    }
}

