/*
 * Decompiled with CFR 0.152.
 */
package net.model3.newfile.selector;

import java.util.regex.Pattern;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.selector.ExcludeSelector;
import net.model3.newfile.selector.NameSelector;
import net.model3.newfile.selector.Selector;

public class SelectorHelper {
    private static final Logger logger = LoggerHelper.getLogger();
    public static final Selector DEFAULT_EXCLUDES;

    public static Pattern convertFilenameMaskToRegex(String string, boolean bl) {
        int n = 0;
        if (!bl) {
            n = 2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '*' && i + 1 < n2 && string.charAt(i + 1) == '*') {
                stringBuilder.append("(.*)");
                continue;
            }
            if (c == '*') {
                stringBuilder.append("([^/\\\\]*)");
                continue;
            }
            if (c == '\\' || c == '/') {
                stringBuilder.append("([/\\\\]+)");
                continue;
            }
            if (c == '.') {
                stringBuilder.append("(\\.)");
                continue;
            }
            stringBuilder.append(c);
        }
        return Pattern.compile(stringBuilder.toString(), n);
    }

    public static boolean match(String string, String string2, boolean bl) {
        return SelectorHelper.convertFilenameMaskToRegex(string, bl).matcher(string2).matches();
    }

    static {
        ExcludeSelector excludeSelector = new ExcludeSelector();
        String[] stringArray = new String[]{"**/CVS", "**/CVS/**", "**/.cvsignore", "**/.svn", "**/.svn/**"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            NameSelector nameSelector = new NameSelector();
            nameSelector.setCaseSensitive(false);
            nameSelector.setPattern(string);
            excludeSelector.add(nameSelector);
        }
        DEFAULT_EXCLUDES = excludeSelector;
    }
}

