/*
 * Decompiled with CFR 0.152.
 */
package net.model3.newfile.selector;

import java.util.regex.Pattern;
import net.model3.newfile.Directory;
import net.model3.newfile.Path;
import net.model3.newfile.selector.Selector;
import net.model3.newfile.selector.SelectorHelper;

public class NameSelector
implements Selector {
    private String _pattern;
    private boolean _caseSensitive = false;
    private Pattern _regex;

    public NameSelector() {
    }

    public NameSelector(String string) {
        this._pattern = string;
    }

    public String getPattern() {
        return this._pattern;
    }

    public void setPattern(String string) {
        this._pattern = string;
        this._regex = null;
    }

    Pattern getRegex() {
        if (this._regex == null) {
            this._regex = SelectorHelper.convertFilenameMaskToRegex(this._pattern, this._caseSensitive);
        }
        return this._regex;
    }

    @Override
    public boolean isSelected(Directory directory, Path path) {
        return this.getRegex().matcher(path.getPathRelativeTo(directory)).matches();
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this._caseSensitive = bl;
        this._regex = null;
    }
}

