/*
 * Decompiled with CFR 0.152.
 */
package net.model3.newfile;

import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import net.model3.newfile.Path;
import net.model3.newfile.selector.AndSelector;
import net.model3.newfile.selector.FileFilterSelector;
import net.model3.newfile.selector.NameSelector;
import net.model3.newfile.selector.OrSelector;
import net.model3.newfile.selector.Selector;
import net.model3.newfile.selector.SelectorHelper;

public class PathIterator {
    private boolean recurseIntoExcludedDirectories_ = true;
    private boolean recurse_ = true;
    private boolean useDefaultExcludes_ = true;
    private List<String> includePatterns_ = new ArrayList<String>();
    private FileFilter fileFilter_;
    private Directory root_;

    public PathIterator() {
    }

    public PathIterator(Directory directory) {
        this.root_ = directory;
    }

    public PathIterator(Directory directory, String string) {
        this.root_ = directory;
        this.addIncludePatterns(string);
    }

    public FileFilter getFileFilter() {
        return this.fileFilter_;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter_ = fileFilter;
    }

    public boolean getRecurse() {
        return this.recurse_;
    }

    public void setRecurse(boolean bl) {
        this.recurse_ = bl;
    }

    public boolean getRecurseIntoExcludedDirectories() {
        return this.recurseIntoExcludedDirectories_;
    }

    public void setRecurseIntoExcludedDirectories(boolean bl) {
        this.recurseIntoExcludedDirectories_ = bl;
    }

    public Directory getRoot() {
        return this.root_;
    }

    public void setRoot(Directory directory) {
        this.root_ = directory;
    }

    public boolean getUseDefaultExcludes() {
        return this.useDefaultExcludes_;
    }

    public void setUseDefaultExcludes(boolean bl) {
        this.useDefaultExcludes_ = bl;
    }

    public Iterator<Path> iteratePaths() {
        return this.listPaths().iterator();
    }

    public Iterator<File> iterateFiles() {
        return this.listFiles().iterator();
    }

    public Iterator<Directory> iterateDirectory() {
        return this.listDirectories().iterator();
    }

    public List<Path> listPaths() {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        this.initLoadFileList(arrayList, null, null);
        return arrayList;
    }

    public List<Directory> listDirectories() {
        ArrayList<Directory> arrayList = new ArrayList<Directory>();
        this.initLoadFileList(null, arrayList, null);
        return arrayList;
    }

    public List<File> listFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        this.initLoadFileList(null, null, arrayList);
        return arrayList;
    }

    private Selector createSelector() {
        AndSelector andSelector = new AndSelector();
        if (this.useDefaultExcludes_) {
            andSelector.add(SelectorHelper.DEFAULT_EXCLUDES);
        }
        if (this.includePatterns_.size() > 0) {
            OrSelector orSelector = new OrSelector();
            for (String string : this.includePatterns_) {
                NameSelector nameSelector = new NameSelector(string);
                orSelector.add(nameSelector);
            }
            andSelector.add(orSelector);
        }
        if (this.fileFilter_ != null) {
            andSelector.add(new FileFilterSelector(this.fileFilter_));
        }
        return andSelector;
    }

    private void initLoadFileList(List<Path> list, List<Directory> list2, List<File> list3) {
        if (this.root_ == null) {
            throw new IllegalArgumentException("no root set");
        }
        this.loadFileList(this.root_, list, list2, list3, this.createSelector());
    }

    private void loadFileList(Directory directory, List<Path> list, List<Directory> list2, List<File> list3, Selector selector) {
        if (!directory.exists()) {
            throw new RuntimeException(directory.getCanonicalPath() + " does not exist");
        }
        java.io.File[] fileArray = directory.asFile().listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            java.io.File file = fileArray[i];
            boolean bl = file.isDirectory();
            Path path = bl ? new Directory(file) : new File(file);
            boolean bl2 = selector.isSelected(this.root_, path);
            if (bl && this.recurse_ && (this.recurseIntoExcludedDirectories_ || bl2)) {
                this.loadFileList((Directory)path, list, list2, list3, selector);
            }
            if (!bl2) continue;
            if (list != null) {
                list.add(path);
            }
            if (bl && list2 != null) {
                list2.add((Directory)path);
            }
            if (bl || list3 == null) continue;
            list3.add((File)path);
        }
    }

    public void addIncludePatterns(String string) {
        for (String string2 : string.split(";")) {
            this.includePatterns_.add(string2);
        }
    }

    public static void main(String[] stringArray) {
        PathIterator pathIterator = new PathIterator();
        pathIterator.setRoot(new Directory("c:/code/birthprint/images/"));
        pathIterator.addIncludePatterns("*.png");
        for (Path path : pathIterator.listPaths()) {
            System.out.println(path.getCanonicalPath());
        }
    }
}

